/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.openstack4j.openstack.vpc.v1.domain.SecurityGroupRule;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.huaweicloud.HuaweiCloudUtils;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.model.HuaweiCloudSecurityGroup;
import com.netflix.spinnaker.clouddriver.huaweicloud.model.HuaweiCloudSecurityGroupCacheData;
import com.netflix.spinnaker.clouddriver.model.AddressableRange;
import com.netflix.spinnaker.clouddriver.model.SecurityGroup;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupProvider;
import com.netflix.spinnaker.clouddriver.model.securitygroups.IpRangeRule;
import com.netflix.spinnaker.clouddriver.model.securitygroups.Rule;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HuaweiCloudSecurityGroupProvider
implements SecurityGroupProvider<HuaweiCloudSecurityGroup> {
    private static final Logger log = HuaweiCloudUtils.getLogger(HuaweiCloudSecurityGroupProvider.class);
    private final Cache cacheView;
    private final ObjectMapper objectMapper;

    @Autowired
    public HuaweiCloudSecurityGroupProvider(Cache cacheView, ObjectMapper objectMapper) {
        this.cacheView = cacheView;
        this.objectMapper = objectMapper;
    }

    public String getCloudProvider() {
        return "huaweicloud";
    }

    public Set<HuaweiCloudSecurityGroup> getAll(boolean includeRules) {
        Set<HuaweiCloudSecurityGroup> result = HuaweiCloudSecurityGroupProvider.loadResults(Keys.getSecurityGroupKey("*", "*", "*", "*"), this.cacheView, this.objectMapper, includeRules);
        log.debug("get all security group, return {} groups", (Object)result.size());
        return result;
    }

    public Set<HuaweiCloudSecurityGroup> getAllByRegion(boolean includeRules, String region) {
        Set<HuaweiCloudSecurityGroup> result = HuaweiCloudSecurityGroupProvider.loadResults(Keys.getSecurityGroupKey("*", "*", "*", region), this.cacheView, this.objectMapper, includeRules);
        log.debug("get all security group by region={}, return {} groups", (Object)region, (Object)result.size());
        return result;
    }

    public Set<HuaweiCloudSecurityGroup> getAllByAccount(boolean includeRules, String account) {
        Set<HuaweiCloudSecurityGroup> result = HuaweiCloudSecurityGroupProvider.loadResults(Keys.getSecurityGroupKey("*", "*", account, "*"), this.cacheView, this.objectMapper, includeRules);
        log.debug("get all security group by account={}, return {} groups", (Object)account, (Object)result.size());
        return result;
    }

    public Set<HuaweiCloudSecurityGroup> getAllByAccountAndName(boolean includeRules, String account, String name) {
        Set<HuaweiCloudSecurityGroup> result = HuaweiCloudSecurityGroupProvider.loadResults(Keys.getSecurityGroupKey(name, "*", account, "*"), this.cacheView, this.objectMapper, includeRules);
        log.debug("get all security group by account={} and group name={}, return {} groups", new Object[]{account, name, result.size()});
        return result;
    }

    public Set<HuaweiCloudSecurityGroup> getAllByAccountAndRegion(boolean includeRules, String account, String region) {
        Set<HuaweiCloudSecurityGroup> result = HuaweiCloudSecurityGroupProvider.loadResults(Keys.getSecurityGroupKey("*", "*", account, region), this.cacheView, this.objectMapper, includeRules);
        log.debug("get all security group by account={} and region={}, return {} groups", new Object[]{account, region, result.size()});
        return result;
    }

    public HuaweiCloudSecurityGroup get(String account, String region, String name, String vpcId) {
        Set<HuaweiCloudSecurityGroup> result = HuaweiCloudSecurityGroupProvider.loadResults(Keys.getSecurityGroupKey(name, "*", account, region), this.cacheView, this.objectMapper, true);
        log.debug("get all security group by account={}, region={}, group name={} and vpc id={}, return {} groups", new Object[]{account, region, name, vpcId, result.size()});
        return result.stream().filter(it -> {
            boolean e2;
            boolean e1 = HuaweiCloudUtils.isEmptyStr(it.getVpcId());
            return e1 == (e2 = HuaweiCloudUtils.isEmptyStr(vpcId)) && (e1 || vpcId.equals(it.getVpcId()));
        }).findFirst().orElse(null);
    }

    public HuaweiCloudSecurityGroup getById(String account, String region, String id, String vpcId) {
        Set<HuaweiCloudSecurityGroup> result = HuaweiCloudSecurityGroupProvider.loadResults(Keys.getSecurityGroupKey("*", id, account, region), this.cacheView, this.objectMapper, true);
        return result.stream().filter(it -> {
            boolean e2;
            boolean e1 = HuaweiCloudUtils.isEmptyStr(it.getVpcId());
            return e1 == (e2 = HuaweiCloudUtils.isEmptyStr(vpcId)) && (e1 || vpcId.equals(it.getVpcId()));
        }).findFirst().orElse(null);
    }

    private static Set<HuaweiCloudSecurityGroup> loadResults(String pattern, Cache cacheView, ObjectMapper objectMapper, boolean includeRules) {
        Collection data = cacheView.getAll(Keys.Namespace.SECURITY_GROUPS.ns, cacheView.filterIdentifiers(Keys.Namespace.SECURITY_GROUPS.ns, pattern));
        if (HuaweiCloudUtils.isEmptyCollection(data)) {
            return Collections.emptySet();
        }
        return data.stream().map(cacheData -> HuaweiCloudSecurityGroupProvider.fromCacheData(cacheData, objectMapper, includeRules)).filter(it -> it != null).collect(Collectors.toSet());
    }

    private static HuaweiCloudSecurityGroup fromCacheData(CacheData cacheData, ObjectMapper objectMapper, boolean includeRules) {
        Map<String, String> parts = Keys.parse(cacheData.getId(), Keys.Namespace.SECURITY_GROUPS);
        if (parts.isEmpty()) {
            return null;
        }
        HuaweiCloudSecurityGroupCacheData segCacheData = (HuaweiCloudSecurityGroupCacheData)objectMapper.convertValue((Object)cacheData.getAttributes(), HuaweiCloudSecurityGroupCacheData.class);
        return new HuaweiCloudSecurityGroup(parts.get("id"), parts.get("name"), parts.get("region"), parts.get("account"), parts.get("application"), segCacheData.getSecurityGroup().getVpcId(), includeRules ? HuaweiCloudSecurityGroupProvider.buildInboundRules(segCacheData) : Collections.emptySet(), Collections.emptySet());
    }

    private static Set<Rule> buildInboundRules(HuaweiCloudSecurityGroupCacheData segCacheData) {
        if (HuaweiCloudUtils.isEmptyCollection(segCacheData.getSecurityGroup().getSecurityGroupRules())) {
            return Collections.emptySet();
        }
        return segCacheData.getSecurityGroup().getSecurityGroupRules().stream().filter(rule -> "ingress".equals(rule.getDirection())).map(rule -> {
            TreeSet<Rule.PortRange> portRanges = new TreeSet<Rule.PortRange>();
            portRanges.add(HuaweiCloudSecurityGroupProvider.buildPortRange(rule));
            if (!HuaweiCloudUtils.isEmptyStr(rule.getRemoteIpPrefix())) {
                String[] parts = rule.getRemoteIpPrefix().split("/");
                String ip = parts[0];
                String cidr = "";
                if (parts.length > 1 && Integer.parseInt(parts[1]) != 32) {
                    cidr = rule.getRemoteIpPrefix();
                    ip = "";
                }
                return new IpRangeRule(new AddressableRange(ip, cidr), rule.getProtocol(), portRanges, rule.getDescription());
            }
            if (!HuaweiCloudUtils.isEmptyStr(rule.getRemoteGroupId())) {
                return com.netflix.spinnaker.clouddriver.model.securitygroups.SecurityGroupRule.builder().portRanges(portRanges).protocol(rule.getProtocol()).securityGroup((SecurityGroup)HuaweiCloudSecurityGroupProvider.buildRemoteSecurityGroup(segCacheData.getRelevantSecurityGroups().get(rule.getRemoteGroupId()))).build();
            }
            return null;
        }).filter(it -> it != null).collect(Collectors.toSet());
    }

    private static Rule.PortRange buildPortRange(SecurityGroupRule rule) {
        Rule.PortRange portRange = new Rule.PortRange();
        if (HuaweiCloudUtils.isEmptyStr(rule.getProtocol()) || !"icmp".equals(rule.getProtocol().toLowerCase())) {
            portRange.setStartPort(rule.getPortRangeMin() != null ? rule.getPortRangeMin() : new Integer(1));
            portRange.setEndPort(rule.getPortRangeMax() != null ? rule.getPortRangeMax() : new Integer(65535));
            return portRange;
        }
        int startPort = rule.getPortRangeMin() != null ? rule.getPortRangeMin() : 0;
        int endPort = rule.getPortRangeMax() != null ? rule.getPortRangeMax() : 255;
        portRange.setStartPort(new Integer(startPort <= endPort ? startPort : endPort));
        portRange.setEndPort(new Integer(startPort <= endPort ? endPort : startPort));
        return portRange;
    }

    private static HuaweiCloudSecurityGroup buildRemoteSecurityGroup(String cacheDataId) {
        Map<String, String> parts = Keys.parse(cacheDataId, Keys.Namespace.SECURITY_GROUPS);
        if (parts.isEmpty()) {
            return null;
        }
        return new HuaweiCloudSecurityGroup(parts.get("id"), parts.get("name"), parts.get("region"), parts.get("account"), parts.get("application"), "", null, null);
    }
}

