/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.openstack4j.openstack.vpc.v1.domain.Subnet;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.huaweicloud.HuaweiCloudUtils;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.model.HuaweiCloudSubnet;
import com.netflix.spinnaker.clouddriver.model.SubnetProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class HuaweiCloudSubnetProvider
implements SubnetProvider<HuaweiCloudSubnet> {
    private final Cache cacheView;
    private final ObjectMapper objectMapper;

    @Autowired
    public HuaweiCloudSubnetProvider(Cache cacheView, ObjectMapper objectMapper) {
        this.cacheView = cacheView;
        this.objectMapper = objectMapper;
    }

    public String getCloudProvider() {
        return "huaweicloud";
    }

    public Set<HuaweiCloudSubnet> getAll() {
        Collection data = this.cacheView.getAll(Keys.Namespace.SUBNETS.ns, this.cacheView.filterIdentifiers(Keys.Namespace.SUBNETS.ns, Keys.getSubnetKey("*", "*", "*")));
        if (HuaweiCloudUtils.isEmptyCollection(data)) {
            return Collections.emptySet();
        }
        return data.stream().map(cacheData -> this.fromCacheData((CacheData)cacheData)).filter(it -> it != null).collect(Collectors.toSet());
    }

    private HuaweiCloudSubnet fromCacheData(CacheData cacheData) {
        Map<String, String> parts = Keys.parse(cacheData.getId(), Keys.Namespace.SUBNETS);
        if (parts.isEmpty()) {
            return null;
        }
        Subnet subnet = (Subnet)this.objectMapper.convertValue((Object)cacheData.getAttributes(), Subnet.class);
        return new HuaweiCloudSubnet(parts.get("id"), subnet.getName(), subnet.getCidr(), subnet.getVpcId(), parts.get("region"), parts.get("account"), "n/a");
    }
}

