/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huawei.openstack4j.api.OSClient;
import com.huawei.openstack4j.api.client.IOSClientBuilder;
import com.huawei.openstack4j.core.transport.Config;
import com.huawei.openstack4j.model.common.Identifier;
import com.huawei.openstack4j.model.identity.v3.Token;
import com.huawei.openstack4j.openstack.OSFactory;
import com.netflix.spinnaker.clouddriver.huaweicloud.client.AuthorizedClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiCloudCredentials
implements AuthorizedClientProvider {
    private final Logger log = LoggerFactory.getLogger(HuaweiCloudCredentials.class);
    private final String authUrl;
    private final String username;
    @JsonIgnore
    private final String password;
    private final String projectName;
    private final String domainName;
    private final Boolean insecure;
    @JsonIgnore
    private Token token = null;

    public HuaweiCloudCredentials(String authUrl, String username, String password, String projectName, String domainName, Boolean insecure) {
        this.authUrl = authUrl;
        this.username = username;
        this.password = password;
        this.projectName = projectName;
        this.domainName = domainName;
        this.insecure = insecure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSClient getAuthClient() {
        Config config = this.insecure != false ? Config.newConfig().withSSLVerificationDisabled() : Config.newConfig();
        OSClient.OSClientV3 client = null;
        try {
            if (this.needRefreshToken()) {
                HuaweiCloudCredentials huaweiCloudCredentials = this;
                synchronized (huaweiCloudCredentials) {
                    if (this.needRefreshToken()) {
                        this.token = ((OSClient.OSClientV3)((IOSClientBuilder.V3)((IOSClientBuilder.V3)OSFactory.builderV3().withConfig(config)).endpoint(this.authUrl)).credentials(this.username, this.password, Identifier.byName((String)this.domainName)).scopeToProject(Identifier.byName((String)this.projectName), Identifier.byName((String)this.domainName)).authenticate()).getToken();
                    }
                }
            }
            client = OSFactory.clientFromToken((Token)this.token, (Config)config);
        }
        catch (Exception e) {
            this.log.error("Error building authorized client, error=%s", (Throwable)e);
        }
        return client;
    }

    private boolean needRefreshToken() {
        long expires;
        if (this.token == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        return now >= (expires = this.token.getExpires().getTime());
    }
}

