/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.security;

import com.netflix.spinnaker.clouddriver.huaweicloud.config.HuaweiCloudConfigurationProperties;
import com.netflix.spinnaker.clouddriver.huaweicloud.security.HuaweiCloudNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import com.netflix.spinnaker.clouddriver.security.CredentialsInitializerSynchronizable;
import com.netflix.spinnaker.clouddriver.security.ProviderUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class HuaweiCloudCredentialsInitializer
implements CredentialsInitializerSynchronizable {
    private final Logger log = LoggerFactory.getLogger(HuaweiCloudCredentialsInitializer.class);

    @Scope(value="prototype")
    @Bean
    @ConfigurationProperties(value="huaweicloud")
    HuaweiCloudConfigurationProperties huaweiCloudConfigurationProperties() {
        return new HuaweiCloudConfigurationProperties();
    }

    @Bean
    List<HuaweiCloudNamedAccountCredentials> synchronizeHuaweiCloudNamedAccountCredentials(HuaweiCloudConfigurationProperties huaweiCloudConfigurationProperties, AccountCredentialsRepository accountCredentialsRepository) {
        List result = ProviderUtils.calculateAccountDeltas((Object)accountCredentialsRepository, HuaweiCloudNamedAccountCredentials.class, huaweiCloudConfigurationProperties.getAccounts());
        List accountsToAdd = (List)result.get(0);
        accountsToAdd.forEach(managedAccount -> {
            try {
                HuaweiCloudNamedAccountCredentials account = new HuaweiCloudNamedAccountCredentials(managedAccount.getName(), managedAccount.getEnvironment(), managedAccount.getAccountType(), managedAccount.getAuthUrl(), managedAccount.getUsername(), managedAccount.getPassword(), managedAccount.getProjectName(), managedAccount.getDomainName(), managedAccount.getInsecure(), managedAccount.getRegions());
                accountCredentialsRepository.save(managedAccount.getName(), (AccountCredentials)account);
            }
            catch (Exception e) {
                this.log.error("Could not load account:{} for huaweicloud, error={}", (Object)managedAccount.getName(), (Object)e);
            }
        });
        List accountNamesToDelete = (List)result.get(1);
        ProviderUtils.unscheduleAndDeregisterAgents((Object)accountNamesToDelete, null);
        return accountCredentialsRepository.getAll().stream().filter(it -> it instanceof HuaweiCloudNamedAccountCredentials).collect(Collectors.toList());
    }
}

