/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huawei.openstack4j.model.compute.ext.AvailabilityZone;
import com.netflix.spinnaker.clouddriver.huaweicloud.client.HuaweiCloudClient;
import com.netflix.spinnaker.clouddriver.huaweicloud.client.HuaweiCloudClientImpl;
import com.netflix.spinnaker.clouddriver.huaweicloud.security.HuaweiCloudCredentials;
import com.netflix.spinnaker.clouddriver.security.AbstractAccountCredentials;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class HuaweiCloudNamedAccountCredentials
extends AbstractAccountCredentials<HuaweiCloudCredentials> {
    private final String name;
    private final String environment;
    private final String accountType;
    private final List<String> regions;
    private final Map<String, List<String>> regionToZones;
    private final HuaweiCloudCredentials credentials;
    @JsonIgnore
    private final HuaweiCloudClient cloudClient;

    public HuaweiCloudNamedAccountCredentials(String name, String environment, String accountType, String authUrl, String username, String password, String projectName, String domainName, Boolean insecure, List<String> regions) {
        this.name = name;
        this.environment = environment;
        this.accountType = accountType;
        this.regions = regions;
        this.credentials = new HuaweiCloudCredentials(authUrl, username, password, projectName, domainName, insecure);
        this.cloudClient = new HuaweiCloudClientImpl(this.credentials);
        this.regionToZones = new HashMap<String, List<String>>();
        regions.forEach(region -> {
            List<String> result = this.getZonesOfRegion((String)region);
            if (!result.isEmpty()) {
                this.regionToZones.put((String)region, result);
            }
        });
    }

    public String getCloudProvider() {
        return "huaweicloud";
    }

    public List<String> getRequiredGroupMembership() {
        return new ArrayList<String>();
    }

    private List<String> getZonesOfRegion(String region) {
        List<? extends AvailabilityZone> zones = this.cloudClient.getZones(region);
        return zones.stream().filter(zone -> zone.getZoneState().getAvailable()).map(zone -> zone.getZoneName()).collect(Collectors.toList());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public String getAccountType() {
        return this.accountType;
    }

    @Generated
    public List<String> getRegions() {
        return this.regions;
    }

    @Generated
    public Map<String, List<String>> getRegionToZones() {
        return this.regionToZones;
    }

    @Generated
    public HuaweiCloudCredentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public HuaweiCloudClient getCloudClient() {
        return this.cloudClient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HuaweiCloudNamedAccountCredentials)) {
            return false;
        }
        HuaweiCloudNamedAccountCredentials other = (HuaweiCloudNamedAccountCredentials)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$accountType = this.getAccountType();
        String other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
            return false;
        }
        List<String> this$regions = this.getRegions();
        List<String> other$regions = other.getRegions();
        if (this$regions == null ? other$regions != null : !((Object)this$regions).equals(other$regions)) {
            return false;
        }
        Map<String, List<String>> this$regionToZones = this.getRegionToZones();
        Map<String, List<String>> other$regionToZones = other.getRegionToZones();
        if (this$regionToZones == null ? other$regionToZones != null : !((Object)this$regionToZones).equals(other$regionToZones)) {
            return false;
        }
        HuaweiCloudCredentials this$credentials = this.getCredentials();
        HuaweiCloudCredentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        HuaweiCloudClient this$cloudClient = this.getCloudClient();
        HuaweiCloudClient other$cloudClient = other.getCloudClient();
        return !(this$cloudClient == null ? other$cloudClient != null : !this$cloudClient.equals(other$cloudClient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HuaweiCloudNamedAccountCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
        List<String> $regions = this.getRegions();
        result = result * 59 + ($regions == null ? 43 : ((Object)$regions).hashCode());
        Map<String, List<String>> $regionToZones = this.getRegionToZones();
        result = result * 59 + ($regionToZones == null ? 43 : ((Object)$regionToZones).hashCode());
        HuaweiCloudCredentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        HuaweiCloudClient $cloudClient = this.getCloudClient();
        result = result * 59 + ($cloudClient == null ? 43 : $cloudClient.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HuaweiCloudNamedAccountCredentials(name=" + this.getName() + ", environment=" + this.getEnvironment() + ", accountType=" + this.getAccountType() + ", regions=" + String.valueOf(this.getRegions()) + ", regionToZones=" + String.valueOf(this.getRegionToZones()) + ", credentials=" + String.valueOf(this.getCredentials()) + ", cloudClient=" + String.valueOf(this.getCloudClient()) + ")";
    }
}

