/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Keys {
    private static final Logger log = LoggerFactory.getLogger(Keys.class);
    private static final String provider = "kubernetes.v2";

    private static String createKeyFromParts(Object ... elems) {
        List components = Arrays.stream(elems).map(s -> s == null ? "" : s.toString()).map(s -> s.contains(":") ? s.replaceAll(":", ";") : s).collect(Collectors.toList());
        components.add(0, provider);
        return String.join((CharSequence)":", components);
    }

    public static Optional<CacheKey> parseKey(String key) {
        String[] parts = key.split(":", -1);
        if (parts.length < 3 || !parts[0].equals(provider)) {
            return Optional.empty();
        }
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].contains(";")) continue;
            parts[i] = parts[i].replaceAll(";", ":");
        }
        try {
            Kind kind = Kind.fromString(parts[1]);
            switch (kind) {
                case LOGICAL: {
                    return Optional.of(Keys.parseLogicalKey(parts));
                }
                case ARTIFACT: {
                    return Optional.empty();
                }
                case INFRASTRUCTURE: {
                    return Optional.of(new InfrastructureCacheKey(parts));
                }
            }
            throw new IllegalArgumentException("Unknown kind " + String.valueOf((Object)kind));
        }
        catch (IllegalArgumentException e) {
            log.warn("Kubernetes owned kind with unknown key structure '{}': {} (perhaps try flushing all clouddriver:* redis keys)", new Object[]{key, parts, e});
            return Optional.empty();
        }
    }

    private static CacheKey parseLogicalKey(String[] parts) {
        assert (parts.length >= 3);
        LogicalKind logicalKind = LogicalKind.fromString(parts[2]);
        switch (logicalKind) {
            case APPLICATIONS: {
                return new ApplicationCacheKey(parts);
            }
            case CLUSTERS: {
                return new ClusterCacheKey(parts);
            }
        }
        throw new IllegalArgumentException("Unknown kind " + String.valueOf((Object)logicalKind));
    }

    public static enum Kind {
        LOGICAL,
        ARTIFACT,
        INFRASTRUCTURE;

        private final String lcName = this.name().toLowerCase();

        public String toString() {
            return this.lcName;
        }

        @JsonCreator
        public static Kind fromString(String name) {
            try {
                return Kind.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("No matching kind with name " + name + " exists");
            }
        }
    }

    public static abstract class CacheKey {
        private final String provider = "kubernetes";

        public abstract String getGroup();

        public abstract String getName();

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$provider = this.getProvider();
            String other$provider = other.getProvider();
            return !(this$provider == null ? other$provider != null : !this$provider.equals(other$provider));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $provider = this.getProvider();
            result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
            return result;
        }

        @Generated
        public String getProvider() {
            return this.provider;
        }
    }

    public static class InfrastructureCacheKey
    extends CacheKey {
        private static final Kind kind = Kind.INFRASTRUCTURE;
        private final KubernetesKind kubernetesKind;
        private final String account;
        private final String namespace;
        private final String name;

        protected InfrastructureCacheKey(String[] parts) {
            if (parts.length != 6) {
                throw new IllegalArgumentException("Malformed infrastructure key " + Arrays.toString(parts));
            }
            this.kubernetesKind = KubernetesKind.fromString(parts[2]);
            this.account = parts[3];
            this.namespace = parts[4];
            this.name = parts[5];
        }

        public InfrastructureCacheKey(KubernetesManifest manifest, String account) {
            this(manifest.getKind(), account, manifest.getNamespace(), manifest.getName());
        }

        public static String createKey(KubernetesKind kubernetesKind, String account, String namespace, String name) {
            return Keys.createKeyFromParts(new Object[]{kind, kubernetesKind, account, namespace, name});
        }

        public static String createKey(String account, KubernetesCoordinates coords) {
            return Keys.createKeyFromParts(new Object[]{kind, coords.getKind(), account, coords.getNamespace(), coords.getName()});
        }

        public static String createKey(KubernetesManifest manifest, String account) {
            return InfrastructureCacheKey.createKey(manifest.getKind(), account, manifest.getNamespace(), manifest.getName());
        }

        public String toString() {
            return Keys.createKeyFromParts(new Object[]{kind, this.kubernetesKind, this.account, this.namespace, this.name});
        }

        @Override
        public String getGroup() {
            return this.kubernetesKind.toString();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InfrastructureCacheKey)) {
                return false;
            }
            InfrastructureCacheKey other = (InfrastructureCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            KubernetesKind this$kubernetesKind = this.getKubernetesKind();
            KubernetesKind other$kubernetesKind = other.getKubernetesKind();
            if (this$kubernetesKind == null ? other$kubernetesKind != null : !((Object)this$kubernetesKind).equals(other$kubernetesKind)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InfrastructureCacheKey;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            KubernetesKind $kubernetesKind = this.getKubernetesKind();
            result = result * 59 + ($kubernetesKind == null ? 43 : ((Object)$kubernetesKind).hashCode());
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public KubernetesKind getKubernetesKind() {
            return this.kubernetesKind;
        }

        @Generated
        public String getAccount() {
            return this.account;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public InfrastructureCacheKey(KubernetesKind kubernetesKind, String account, String namespace, String name) {
            this.kubernetesKind = kubernetesKind;
            this.account = account;
            this.namespace = namespace;
            this.name = name;
        }

        @Generated
        public static Kind getKind() {
            return kind;
        }
    }

    public static enum LogicalKind {
        APPLICATIONS,
        CLUSTERS;

        private final String lcName = this.name().toLowerCase();

        public static boolean isLogicalGroup(String group) {
            return group.equals(APPLICATIONS.toString()) || group.equals(CLUSTERS.toString());
        }

        public String toString() {
            return this.lcName;
        }

        public String singular() {
            String name = this.toString();
            return name.substring(0, name.length() - 1);
        }

        @JsonCreator
        public static LogicalKind fromString(String name) {
            try {
                return LogicalKind.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("No matching kind with name " + name + " exists");
            }
        }
    }

    public static class ApplicationCacheKey
    extends LogicalKey {
        private static final LogicalKind logicalKind = LogicalKind.APPLICATIONS;
        private final String name;

        protected ApplicationCacheKey(String[] parts) {
            if (parts.length != 4) {
                throw new IllegalArgumentException("Malformed application key" + Arrays.toString(parts));
            }
            this.name = parts[3];
        }

        public static String createKey(String name) {
            return Keys.createKeyFromParts(new Object[]{ApplicationCacheKey.getKind(), logicalKind, name});
        }

        @Override
        public LogicalKind getLogicalKind() {
            return logicalKind;
        }

        public String toString() {
            return Keys.createKeyFromParts(new Object[]{ApplicationCacheKey.getKind(), logicalKind, this.name});
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationCacheKey)) {
                return false;
            }
            ApplicationCacheKey other = (ApplicationCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApplicationCacheKey;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public ApplicationCacheKey(String name) {
            this.name = name;
        }
    }

    public static class ClusterCacheKey
    extends LogicalKey {
        private static final LogicalKind logicalKind = LogicalKind.CLUSTERS;
        private final String account;
        private final String application;
        private final String name;

        public ClusterCacheKey(String[] parts) {
            if (parts.length != 6) {
                throw new IllegalArgumentException("Malformed cluster key " + Arrays.toString(parts));
            }
            this.account = parts[3];
            this.application = parts[4];
            this.name = parts[5];
        }

        public static String createKey(String account, String application, String name) {
            return Keys.createKeyFromParts(new Object[]{ClusterCacheKey.getKind(), logicalKind, account, application, name});
        }

        @Override
        public LogicalKind getLogicalKind() {
            return logicalKind;
        }

        public String toString() {
            return Keys.createKeyFromParts(new Object[]{ClusterCacheKey.getKind(), logicalKind, this.account, this.application, this.name});
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterCacheKey)) {
                return false;
            }
            ClusterCacheKey other = (ClusterCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$application = this.getApplication();
            String other$application = other.getApplication();
            if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClusterCacheKey;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $application = this.getApplication();
            result = result * 59 + ($application == null ? 43 : $application.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String getAccount() {
            return this.account;
        }

        @Generated
        public String getApplication() {
            return this.application;
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public ClusterCacheKey(String account, String application, String name) {
            this.account = account;
            this.application = application;
            this.name = name;
        }
    }

    public static abstract class LogicalKey
    extends CacheKey {
        private static final Kind kind = Kind.LOGICAL;

        public abstract LogicalKind getLogicalKind();

        @Override
        public final String getGroup() {
            return this.getLogicalKind().toString();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogicalKey)) {
                return false;
            }
            LogicalKey other = (LogicalKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LogicalKey;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        public static Kind getKind() {
            return kind;
        }
    }
}

