/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.moniker.Moniker;
import com.netflix.spinnaker.moniker.Namer;
import io.kubernetes.client.openapi.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCacheDataConverter {
    private static final Logger log = LoggerFactory.getLogger(KubernetesCacheDataConverter.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final JSON json = new JSON();
    private static final int logicalTtlSeconds = Math.toIntExact(TimeUnit.MINUTES.toSeconds(10L));
    private static final int infrastructureTtlSeconds = -1;
    private static final List<KubernetesKind> stickyKinds = Arrays.asList(KubernetesKind.SERVICE, KubernetesKind.POD);
    private static final ImmutableSet<SpinnakerKind> logicalRelationshipKinds = ImmutableSet.of((Object)((Object)SpinnakerKind.LOAD_BALANCERS), (Object)((Object)SpinnakerKind.SECURITY_GROUPS), (Object)((Object)SpinnakerKind.SERVER_GROUPS), (Object)((Object)SpinnakerKind.SERVER_GROUP_MANAGERS));
    private static final ImmutableSet<SpinnakerKind> clusterRelationshipKinds = ImmutableSet.of((Object)((Object)SpinnakerKind.SERVER_GROUPS), (Object)((Object)SpinnakerKind.SERVER_GROUP_MANAGERS));

    @NonnullByDefault
    public static CacheData mergeCacheData(CacheData current, CacheData added) {
        String id = current.getId();
        HashMap attributes = new HashMap(current.getAttributes());
        attributes.putAll(added.getAttributes());
        int ttl = Math.min(current.getTtlSeconds(), added.getTtlSeconds());
        HashMap relationships = new HashMap(current.getRelationships());
        added.getRelationships().forEach((key, value) -> relationships.merge(key, value, (a, b) -> {
            HashSet res = new HashSet(Math.max(a.size(), b.size()));
            res.addAll(a);
            res.addAll(b);
            return res;
        }));
        stickyKinds.forEach(k -> relationships.computeIfAbsent(k.toString(), s -> new ArrayList()));
        return new DefaultCacheData(id, ttl, attributes, relationships);
    }

    @ParametersAreNonnullByDefault
    public static void convertAsResource(KubernetesCacheData kubernetesCacheData, String account, KubernetesSpinnakerKindMap kindMap, Namer<KubernetesManifest> namer, KubernetesManifest manifest, List<KubernetesManifest> resourceRelationships, boolean cacheAllRelationships) {
        KubernetesKind kind = manifest.getKind();
        String name = manifest.getName();
        String namespace = manifest.getNamespace();
        Moniker moniker = namer.deriveMoniker((Object)manifest);
        ImmutableMap attributes = new ImmutableMap.Builder().put((Object)"kind", (Object)kind).put((Object)"apiVersion", (Object)manifest.getApiVersion()).put((Object)"name", (Object)name).put((Object)"namespace", (Object)namespace).put((Object)"fullResourceName", (Object)manifest.getFullResourceName()).put((Object)"manifest", (Object)manifest).put((Object)"moniker", (Object)moniker).build();
        Keys.InfrastructureCacheKey key = new Keys.InfrastructureCacheKey(kind, account, namespace, name);
        kubernetesCacheData.addItem(key, (Map<String, Object>)attributes);
        SpinnakerKind spinnakerKind = kindMap.translateKubernetesKind(kind);
        if (cacheAllRelationships || logicalRelationshipKinds.contains((Object)spinnakerKind)) {
            KubernetesCacheDataConverter.addLogicalRelationships(kubernetesCacheData, key, account, moniker, clusterRelationshipKinds.contains((Object)spinnakerKind));
        }
        kubernetesCacheData.addRelationships(key, (Set<Keys.CacheKey>)KubernetesCacheDataConverter.ownerReferenceRelationships(account, namespace, manifest.getOwnerReferences()));
        kubernetesCacheData.addRelationships(key, (Set<Keys.CacheKey>)KubernetesCacheDataConverter.implicitRelationships(manifest, account, resourceRelationships));
    }

    public static KubernetesManifest getManifest(CacheData cacheData) {
        return (KubernetesManifest)mapper.convertValue(cacheData.getAttributes().get("manifest"), KubernetesManifest.class);
    }

    public static Moniker getMoniker(CacheData cacheData) {
        return (Moniker)mapper.convertValue(cacheData.getAttributes().get("moniker"), Moniker.class);
    }

    public static KubernetesManifest convertToManifest(Object o) {
        return (KubernetesManifest)mapper.convertValue(o, KubernetesManifest.class);
    }

    public static <T> T getResource(Object manifest, Class<T> clazz) {
        return (T)json.deserialize(json.serialize(manifest), clazz);
    }

    private static void addLogicalRelationships(KubernetesCacheData kubernetesCacheData, Keys.CacheKey infrastructureKey, String account, Moniker moniker, boolean hasClusterRelationship) {
        String application = moniker.getApp();
        if (Strings.isNullOrEmpty((String)application)) {
            return;
        }
        Keys.ApplicationCacheKey applicationKey = new Keys.ApplicationCacheKey(application);
        kubernetesCacheData.addRelationship(infrastructureKey, applicationKey);
        String cluster = moniker.getCluster();
        if (hasClusterRelationship && !Strings.isNullOrEmpty((String)cluster)) {
            Keys.ClusterCacheKey clusterKey = new Keys.ClusterCacheKey(account, application, cluster);
            kubernetesCacheData.addRelationship(infrastructureKey, clusterKey);
            kubernetesCacheData.addRelationship(applicationKey, clusterKey);
        }
    }

    @NonnullByDefault
    private static ImmutableSet<Keys.CacheKey> implicitRelationships(KubernetesManifest source, String account, List<KubernetesManifest> manifests) {
        return (ImmutableSet)manifests.stream().map(m -> new Keys.InfrastructureCacheKey(m.getKind(), account, source.getNamespace(), m.getName())).collect(ImmutableSet.toImmutableSet());
    }

    @NonnullByDefault
    static ImmutableSet<Keys.CacheKey> ownerReferenceRelationships(String account, String namespace, List<KubernetesManifest.OwnerReference> references) {
        return (ImmutableSet)references.stream().map(r -> new Keys.InfrastructureCacheKey(r.computedKind(), account, namespace, r.getName())).collect(ImmutableSet.toImmutableSet());
    }

    static void logStratifiedCacheData(String agentType, Map<String, Collection<CacheData>> stratifiedCacheData) {
        for (Map.Entry<String, Collection<CacheData>> entry : stratifiedCacheData.entrySet()) {
            log.info(agentType + ": grouping " + entry.getKey() + " has " + entry.getValue().size() + " entries and " + KubernetesCacheDataConverter.relationshipCount(entry.getValue()) + " relationships");
        }
    }

    private static int relationshipCount(Collection<CacheData> data) {
        return data.stream().mapToInt(KubernetesCacheDataConverter::relationshipCount).sum();
    }

    private static int relationshipCount(CacheData data) {
        return data.getRelationships().values().stream().mapToInt(Collection::size).sum();
    }

    @Generated
    public static int getLogicalTtlSeconds() {
        return logicalTtlSeconds;
    }

    @Generated
    public static int getInfrastructureTtlSeconds() {
        return -1;
    }

    @Generated
    public static List<KubernetesKind> getStickyKinds() {
        return stickyKinds;
    }

    @Generated
    public static ImmutableSet<SpinnakerKind> getLogicalRelationshipKinds() {
        return logicalRelationshipKinds;
    }
}

