/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.Front50ApplicationLoader;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesConfigurationProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;

public class KubernetesCoreCachingAgent
extends KubernetesCachingAgent {
    public KubernetesCoreCachingAgent(KubernetesNamedAccountCredentials namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval, KubernetesConfigurationProperties configurationProperties, KubernetesSpinnakerKindMap kubernetesSpinnakerKindMap, @Nullable Front50ApplicationLoader front50ApplicationLoader) {
        super(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount, agentInterval, configurationProperties, kubernetesSpinnakerKindMap, front50ApplicationLoader);
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        Stream<String> logicalTypes = Stream.of(new Enum[]{Keys.LogicalKind.APPLICATIONS, Keys.LogicalKind.CLUSTERS, Keys.Kind.ARTIFACT}).map(Enum::toString);
        Stream<String> kubernetesTypes = this.filteredPrimaryKinds().stream().map(KubernetesKind::toString);
        return (Collection)Stream.concat(logicalTypes, kubernetesTypes).map(arg_0 -> ((AgentDataType.Authority)AgentDataType.Authority.AUTHORITATIVE).forType(arg_0)).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    protected List<KubernetesKind> primaryKinds() {
        return this.credentials.getGlobalKinds();
    }
}

