/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.clouddriver.model.Health;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1PodStatus;
import java.util.Map;
import lombok.Generated;

public final class KubernetesHealth
implements Health {
    private final HealthState state;
    private final String source;
    private final String type;
    private final String healthClass = "platform";

    public KubernetesHealth(V1PodStatus status) {
        String phase = status.getPhase();
        this.source = "Pod";
        this.type = "kubernetes/pod";
        this.state = phase.equalsIgnoreCase("pending") ? HealthState.Down : (phase.equalsIgnoreCase("running") ? HealthState.Up : HealthState.Unknown);
    }

    public KubernetesHealth(V1ContainerStatus status) {
        this.source = "Container " + status.getName();
        this.type = "kubernetes/container";
        this.state = status.getReady() == false ? HealthState.Down : HealthState.Up;
    }

    public Map<String, Object> toMap() {
        return new ImmutableMap.Builder().put((Object)"state", (Object)this.state.toString()).put((Object)"source", (Object)this.source).put((Object)"type", (Object)this.type).put((Object)"platform", (Object)"platform").build();
    }

    @Generated
    public HealthState getState() {
        return this.state;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getHealthClass() {
        return this.healthClass;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesHealth)) {
            return false;
        }
        KubernetesHealth other = (KubernetesHealth)o;
        HealthState this$state = this.getState();
        HealthState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$healthClass = this.getHealthClass();
        String other$healthClass = other.getHealthClass();
        return !(this$healthClass == null ? other$healthClass != null : !this$healthClass.equals(other$healthClass));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HealthState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $healthClass = this.getHealthClass();
        result = result * 59 + ($healthClass == null ? 43 : $healthClass.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesHealth(state=" + String.valueOf(this.getState()) + ", source=" + this.getSource() + ", type=" + this.getType() + ", healthClass=" + this.getHealthClass() + ")";
    }
}

