/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesApplication;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.model.ApplicationProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesApplicationProvider
implements ApplicationProvider {
    private final KubernetesCacheUtils cacheUtils;

    @Autowired
    KubernetesApplicationProvider(KubernetesCacheUtils cacheUtils) {
        this.cacheUtils = cacheUtils;
    }

    public Set<KubernetesApplication> getApplications(boolean expand) {
        String clusterGlobKey = Keys.ClusterCacheKey.createKey("*", "*", "*");
        Map keysByApplication = this.cacheUtils.getAllKeysMatchingPattern(Keys.LogicalKind.CLUSTERS.toString(), clusterGlobKey).stream().map(Keys::parseKey).filter(Optional::isPresent).map(Optional::get).filter(Keys.ClusterCacheKey.class::isInstance).map(k -> (Keys.ClusterCacheKey)k).collect(Collectors.groupingBy(Keys.ClusterCacheKey::getApplication, Collectors.toSet()));
        return keysByApplication.entrySet().stream().map(e -> new KubernetesApplication((String)e.getKey(), this.groupClustersByAccount((Collection)e.getValue()))).collect(Collectors.toSet());
    }

    public KubernetesApplication getApplication(String name) {
        String clusterGlobKey = Keys.ClusterCacheKey.createKey("*", name, "*");
        List<Keys.ClusterCacheKey> keys = this.cacheUtils.getAllKeysMatchingPattern(Keys.LogicalKind.CLUSTERS.toString(), clusterGlobKey).stream().map(Keys::parseKey).filter(Optional::isPresent).map(Optional::get).filter(Keys.ClusterCacheKey.class::isInstance).map(k -> (Keys.ClusterCacheKey)k).collect(Collectors.toList());
        if (keys.isEmpty()) {
            return null;
        }
        return new KubernetesApplication(name, this.groupClustersByAccount(keys));
    }

    private Map<String, Set<String>> groupClustersByAccount(Collection<Keys.ClusterCacheKey> keys) {
        return keys.stream().collect(Collectors.groupingBy(Keys.ClusterCacheKey::getAccount, Collectors.mapping(Keys.ClusterCacheKey::getName, Collectors.toSet())));
    }
}

