/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesManifestContainer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesAccountResolver;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesManifestContainerBuilder;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesPodMetric;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesManifestProvider {
    private static final Logger log = LoggerFactory.getLogger(KubernetesManifestProvider.class);
    private final KubernetesAccountResolver accountResolver;
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName() + "-%d").build());

    @Autowired
    public KubernetesManifestProvider(KubernetesAccountResolver accountResolver) {
        this.accountResolver = accountResolver;
    }

    @Nullable
    public KubernetesManifestContainer getManifest(String account, String location, String name, boolean includeEvents) {
        KubernetesCoordinates coords;
        Optional<KubernetesCredentials> optionalCredentials = this.accountResolver.getCredentials(account);
        if (!optionalCredentials.isPresent()) {
            return null;
        }
        KubernetesCredentials credentials = optionalCredentials.get();
        try {
            coords = KubernetesCoordinates.builder().namespace(location).fullResourceName(name).build();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        ListenableFuture events = includeEvents ? this.executorService.submit(() -> credentials.eventsFor(coords)) : Futures.immediateFuture((Object)ImmutableList.of());
        ListenableFuture metrics = includeEvents && coords.getKind().equals(KubernetesKind.POD) && credentials.isMetricsEnabled() ? this.executorService.submit(() -> this.getPodMetrics(credentials, coords)) : Futures.immediateFuture((Object)ImmutableList.of());
        KubernetesManifest manifest = credentials.get(coords);
        if (manifest == null) {
            events.cancel(true);
            metrics.cancel(true);
            return null;
        }
        try {
            return KubernetesManifestContainerBuilder.buildManifest(credentials, manifest, (List)events.get(), (List)metrics.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            events.cancel(true);
            metrics.cancel(true);
            log.warn("Interrupted while fetching manifest: {}", (Object)coords);
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private ImmutableList<KubernetesPodMetric.ContainerMetric> getPodMetrics(KubernetesCredentials credentials, KubernetesCoordinates coords) {
        return (ImmutableList)credentials.topPod(coords).stream().map(KubernetesPodMetric::getContainerMetrics).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public List<KubernetesManifest> getClusterAndSortAscending(String account, String location, String kind, String cluster, String app, Sort sort) {
        KubernetesKind kubernetesKind = KubernetesKind.fromString(kind);
        return this.accountResolver.getCredentials(account).map(credentials -> credentials.list(kubernetesKind, location).stream().filter(m -> cluster.equals(KubernetesManifestAnnotater.getManifestCluster(m)) && app.equals(KubernetesManifestAnnotater.getManifestApplication(m))).sorted((m1, m2) -> credentials.getResourcePropertyRegistry().get(kubernetesKind).getHandler().comparatorFor(sort).compare((KubernetesManifest)m1, (KubernetesManifest)m2)).collect(Collectors.toList())).orElseThrow(() -> new IllegalArgumentException("Unable to resolve account: " + account));
    }

    public List<KubernetesCoordinates> getClusterManifestCoordinates(String account, String location, String kind, String app, String cluster) {
        KubernetesKind kubernetesKind = KubernetesKind.fromString(kind);
        return this.accountResolver.getCredentials(account).map(credentials -> credentials.list(kubernetesKind, location).stream().filter(m -> cluster.equals(KubernetesManifestAnnotater.getManifestCluster(m)) && app.equals(KubernetesManifestAnnotater.getManifestApplication(m))).map(KubernetesCoordinates::fromManifest).collect(Collectors.toList())).orElseThrow(() -> new IllegalArgumentException("Unable to resolve account: " + account));
    }

    public static enum Sort {
        AGE,
        SIZE;

    }
}

