/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesRawResource;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesAccountResolver;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.config.RawResourcesEndpointConfig;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesRawResourceProvider {
    private final KubernetesCacheUtils cacheUtils;
    private final KubernetesAccountResolver accountResolver;
    private static final Logger log = LoggerFactory.getLogger(KubernetesRawResourceProvider.class);

    @Autowired
    KubernetesRawResourceProvider(KubernetesCacheUtils cacheUtils, KubernetesAccountResolver accountResolver) {
        this.cacheUtils = cacheUtils;
        this.accountResolver = accountResolver;
    }

    public Set<KubernetesRawResource> getApplicationRawResources(String application) {
        return this.cacheUtils.getSingleEntry(Keys.LogicalKind.APPLICATIONS.toString(), Keys.ApplicationCacheKey.createKey(application)).map(applicationData -> this.fromRawResourceCacheData((Collection<CacheData>)this.cacheUtils.getAllRelationships((CacheData)applicationData))).orElseGet(ImmutableSet::of);
    }

    private Set<KubernetesRawResource> fromRawResourceCacheData(Collection<CacheData> rawResourceData) {
        return rawResourceData.stream().map(KubernetesRawResource::fromCacheData).filter(Objects::nonNull).filter(resource -> this.includeInResponse((KubernetesRawResource)resource)).collect(Collectors.toSet());
    }

    private boolean includeInResponse(KubernetesRawResource resource) {
        Matcher m;
        Optional<KubernetesCredentials> optionalCredentials = this.accountResolver.getCredentials(resource.getAccount());
        if (!optionalCredentials.isPresent()) {
            log.warn("Account {} has no credentials", (Object)resource.getAccount());
            return false;
        }
        KubernetesCredentials credentials = optionalCredentials.get();
        ImmutableSet<KubernetesKind> omitKinds = credentials.getOmitKinds();
        ImmutableSet<KubernetesKind> kinds = credentials.getKinds();
        RawResourcesEndpointConfig epConfig = credentials.getRawResourcesEndpointConfig();
        List<Pattern> kindPatterns = epConfig.getKindPatterns();
        List<Pattern> omitKindPatterns = epConfig.getOmitKindPatterns();
        log.debug("Kinds: {} OmitKinds: {} KindPatterns: {} OmitKindPatterns: {}", new Object[]{kinds.size(), omitKinds.size(), kindPatterns.size(), omitKindPatterns.size()});
        if (!kinds.isEmpty() && !kinds.contains((Object)resource.getKind())) {
            return false;
        }
        if (omitKinds.contains((Object)resource.getKind())) {
            return false;
        }
        for (Pattern p : kindPatterns) {
            m = p.matcher(resource.getKind().toString());
            if (!m.matches()) continue;
            return true;
        }
        for (Pattern p : omitKindPatterns) {
            m = p.matcher(resource.getKind().toString());
            if (!m.matches()) continue;
            return false;
        }
        return true;
    }
}

