/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesServerGroupManager;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.data.KubernetesServerGroupManagerCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.ServerGroupManagerHandler;
import com.netflix.spinnaker.clouddriver.model.ServerGroupManagerProvider;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesServerGroupManagerProvider
implements ServerGroupManagerProvider<KubernetesServerGroupManager> {
    private final KubernetesCacheUtils cacheUtils;
    private final ServerGroupManagerHandler DEFAULT_SERVER_GROUP_MANAGER_HANDLER = new ServerGroupManagerHandler(){};

    @Autowired
    public KubernetesServerGroupManagerProvider(KubernetesCacheUtils cacheUtils) {
        this.cacheUtils = cacheUtils;
    }

    public Set<KubernetesServerGroupManager> getServerGroupManagersByApplication(String application) {
        CacheData applicationDatum = this.cacheUtils.getSingleEntry(Keys.LogicalKind.APPLICATIONS.toString(), Keys.ApplicationCacheKey.createKey(application)).orElse(null);
        if (applicationDatum == null) {
            return null;
        }
        ImmutableCollection<CacheData> serverGroupManagerData = this.cacheUtils.getRelationships(applicationDatum, SpinnakerKind.SERVER_GROUP_MANAGERS);
        ImmutableMultimap<String, CacheData> managerToServerGroupMap = this.cacheUtils.getRelationships((Collection<CacheData>)serverGroupManagerData, SpinnakerKind.SERVER_GROUPS);
        return serverGroupManagerData.stream().map(cd -> this.serverGroupManagerFromCacheData(KubernetesServerGroupManagerCacheData.builder().serverGroupManagerData((CacheData)cd).serverGroupData((Collection<CacheData>)managerToServerGroupMap.get((Object)cd.getId())).build())).collect(Collectors.toSet());
    }

    @Nonnull
    private KubernetesServerGroupManager serverGroupManagerFromCacheData(@Nonnull KubernetesServerGroupManagerCacheData cacheData) {
        KubernetesHandler handler = this.cacheUtils.getHandler(cacheData);
        ServerGroupManagerHandler serverGroupManagerHandler = handler instanceof ServerGroupManagerHandler ? (ServerGroupManagerHandler)((Object)handler) : this.DEFAULT_SERVER_GROUP_MANAGER_HANDLER;
        return serverGroupManagerHandler.fromCacheData(cacheData);
    }
}

