/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.config;

import com.github.wnameless.json.unflattener.JsonUnflattener;
import com.netflix.spinnaker.clouddriver.config.AbstractBootstrapCredentialsConfigurationProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesAccountProperties;
import com.netflix.spinnaker.kork.configserver.CloudConfigResourceService;
import com.netflix.spinnaker.kork.secrets.SecretManager;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.context.ConfigurableApplicationContext;

public class KubernetesCustomAccountConfigurationProvider
extends AbstractBootstrapCredentialsConfigurationProvider<KubernetesAccountProperties> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesCustomAccountConfigurationProvider.class);
    private final String FIRST_ACCOUNT_NAME_KEY = "kubernetes.accounts[0].name";

    public KubernetesCustomAccountConfigurationProvider(ConfigurableApplicationContext applicationContext, CloudConfigResourceService configResourceService, SecretManager secretManager) {
        super(applicationContext, configResourceService, secretManager);
    }

    public KubernetesAccountProperties getConfigurationProperties() {
        return this.getKubernetesAccounts(this.getPropertiesMap("kubernetes.accounts[0].name"));
    }

    private KubernetesAccountProperties getKubernetesAccounts(Map<String, Object> kubernetesPropertiesMap) {
        log.info("Started loading Kubernetes accounts");
        KubernetesAccountProperties accounts = new KubernetesAccountProperties();
        Map propertiesMap = (Map)JsonUnflattener.unflattenAsMap(kubernetesPropertiesMap).get("kubernetes");
        for (Map unflattendAcc : (List)propertiesMap.get("accounts")) {
            BindResult result = this.bind(this.getFlatMap(unflattendAcc), KubernetesAccountProperties.ManagedAccount.class);
            accounts.getAccounts().add((KubernetesAccountProperties.ManagedAccount)result.get());
        }
        log.info("Finished loading kubernetes accounts");
        return accounts;
    }
}

