/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.controllers;

import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesManifestProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.requestqueue.RequestQueue;
import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manifests"})
public class ManifestController {
    private static final Logger log = LoggerFactory.getLogger(ManifestController.class);
    private final KubernetesManifestProvider manifestProvider;
    private final RequestQueue requestQueue;

    @Autowired
    public ManifestController(KubernetesManifestProvider manifestProvider, RequestQueue requestQueue) {
        this.manifestProvider = manifestProvider;
        this.requestQueue = requestQueue;
    }

    @PreAuthorize(value="hasPermission(#account, 'ACCOUNT', 'READ')")
    @PostAuthorize(value="hasPermission(returnObject?.moniker?.app, 'APPLICATION', 'READ')")
    @RequestMapping(value={"/{account:.+}/_/{name:.+}"}, method={RequestMethod.GET})
    Manifest getForAccountAndName(@PathVariable String account, @PathVariable String name, @RequestParam(value="includeEvents", required=false, defaultValue="true") boolean includeEvents) {
        return this.getForAccountLocationAndName(account, "", name, includeEvents);
    }

    @PreAuthorize(value="hasPermission(#account, 'ACCOUNT', 'READ')")
    @PostAuthorize(value="hasPermission(returnObject?.moniker?.app, 'APPLICATION', 'READ')")
    @RequestMapping(value={"/{account:.+}/{location:.+}/{name:.+}"}, method={RequestMethod.GET})
    Manifest getForAccountLocationAndName(@PathVariable String account, @PathVariable String location, @PathVariable String name, @RequestParam(value="includeEvents", required=false, defaultValue="true") boolean includeEvents) {
        Manifest manifest;
        String request = String.format("(account: %s, location: %s, name: %s)", account, location, name);
        try {
            manifest = (Manifest)this.requestQueue.execute(account, () -> this.manifestProvider.getManifest(account, location, name, includeEvents));
        }
        catch (Throwable t) {
            String message = "Failed to read manifest: " + request;
            log.warn(message, t);
            throw new SpinnakerException(message, t);
        }
        if (manifest == null) {
            throw new NotFoundException("Manifest " + request + " not found");
        }
        if (manifest.getMoniker() == null || manifest.getMoniker().getApp() == null) {
            log.error("could not derive a valid moniker with application for manifest: {}", (Object)request);
        }
        return manifest;
    }

    @RequestMapping(value={"/{account:.+}/{name:.+}"}, method={RequestMethod.GET})
    Manifest getForAccountLocationAndName(@PathVariable String account, @PathVariable String name, @RequestParam(value="includeEvents", required=false, defaultValue="true") boolean includeEvents) {
        return this.getForAccountLocationAndName(account, "", name, includeEvents);
    }

    @RequestMapping(value={"/{account:.+}/{location:.+}/{kind:.+}/cluster/{app:.+}/{cluster:.+}/dynamic/{criteria:.+}"}, method={RequestMethod.GET})
    KubernetesCoordinates getDynamicManifestFromCluster(@PathVariable String account, @PathVariable String location, @PathVariable String kind, @PathVariable String app, @PathVariable String cluster, @PathVariable Criteria criteria) {
        List manifests;
        String request = String.format("(account: %s, location: %s, kind: %s, app %s, cluster: %s, criteria: %s)", new Object[]{account, location, kind, app, cluster, criteria});
        try {
            manifests = (List)this.requestQueue.execute(account, () -> this.manifestProvider.getClusterAndSortAscending(account, location, kind, cluster, app, criteria.getSort()));
        }
        catch (Throwable t) {
            log.warn("Failed to read {}", (Object)request, (Object)t);
            return null;
        }
        try {
            switch (criteria) {
                case oldest: 
                case smallest: {
                    return KubernetesCoordinates.fromManifest((KubernetesManifest)manifests.get(0));
                }
                case newest: 
                case largest: {
                    return KubernetesCoordinates.fromManifest((KubernetesManifest)manifests.get(manifests.size() - 1));
                }
                case second_newest: {
                    return KubernetesCoordinates.fromManifest((KubernetesManifest)manifests.get(manifests.size() - 2));
                }
            }
            throw new IllegalArgumentException("Unknown criteria: " + String.valueOf((Object)criteria));
        }
        catch (IndexOutOfBoundsException e) {
            throw new NotFoundException("No manifests matching " + request + " found");
        }
    }

    @RequestMapping(value={"/{account:.+}/{location:.+}/{kind:.+}/cluster/{app:.+}/{cluster:.+}"}, method={RequestMethod.GET})
    List<KubernetesCoordinates> getClusterManifestCoordinates(@PathVariable String account, @PathVariable String location, @PathVariable String kind, @PathVariable String app, @PathVariable String cluster) {
        List coordinates;
        String request = String.format("(account: %s, location: %s, kind: %s, app %s, cluster: %s)", account, location, kind, app, cluster);
        try {
            coordinates = (List)this.requestQueue.execute(account, () -> this.manifestProvider.getClusterManifestCoordinates(account, location, kind, app, cluster));
        }
        catch (Throwable t) {
            log.warn("Failed to read {}", (Object)request, (Object)t);
            return null;
        }
        return coordinates;
    }

    static enum Criteria {
        oldest(KubernetesManifestProvider.Sort.AGE),
        newest(KubernetesManifestProvider.Sort.AGE),
        second_newest(KubernetesManifestProvider.Sort.AGE),
        largest(KubernetesManifestProvider.Sort.SIZE),
        smallest(KubernetesManifestProvider.Sort.SIZE);

        private final KubernetesManifestProvider.Sort sort;

        private Criteria(KubernetesManifestProvider.Sort sort) {
            this.sort = sort;
        }

        @Generated
        public KubernetesManifestProvider.Sort getSort() {
            return this.sort;
        }
    }
}

