/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.converter.manifest;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ResourceVersioner;
import com.netflix.spinnaker.clouddriver.kubernetes.deploy.converters.KubernetesAtomicOperationConverterHelper;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesDeployManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.manifest.KubernetesDeployManifestOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsConverter;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@KubernetesOperation(value="deployManifest")
@Component
public class KubernetesDeployManifestConverter
extends AbstractAtomicOperationsCredentialsConverter<KubernetesNamedAccountCredentials> {
    private static final String KIND_VALUE_LIST = "list";
    private static final String KIND_LIST_ITEMS_KEY = "items";
    private final ResourceVersioner resourceVersioner;

    @Autowired
    public KubernetesDeployManifestConverter(CredentialsRepository<KubernetesNamedAccountCredentials> credentialsRepository, ResourceVersioner resourceVersioner) {
        this.setCredentialsRepository(credentialsRepository);
        this.resourceVersioner = resourceVersioner;
    }

    public AtomicOperation<OperationResult> convertOperation(Map<String, Object> input) {
        return new KubernetesDeployManifestOperation(this.convertDescription(input), this.resourceVersioner);
    }

    public KubernetesDeployManifestDescription convertDescription(Map<String, Object> input) {
        KubernetesDeployManifestDescription mainDescription = KubernetesAtomicOperationConverterHelper.convertDescription(input, this, KubernetesDeployManifestDescription.class);
        return this.convertListDescription(mainDescription);
    }

    private KubernetesDeployManifestDescription convertListDescription(KubernetesDeployManifestDescription mainDescription) {
        if (mainDescription.getManifests() == null) {
            return mainDescription;
        }
        List<KubernetesManifest> updatedManifestList = mainDescription.getManifests().stream().flatMap(singleManifest -> {
            if (singleManifest == null || Strings.isNullOrEmpty((String)singleManifest.getKindName())) {
                return Stream.of(singleManifest);
            }
            if (!singleManifest.getKindName().equalsIgnoreCase(KIND_VALUE_LIST)) {
                return Stream.of(this.updateNamespace(mainDescription, (KubernetesManifest)singleManifest));
            }
            Collection items = (Collection)singleManifest.get(KIND_LIST_ITEMS_KEY);
            if (items == null) {
                return Stream.of(new KubernetesManifest[0]);
            }
            return items.stream().map(i -> {
                KubernetesManifest manifest = (KubernetesManifest)this.getObjectMapper().convertValue(i, KubernetesManifest.class);
                return this.updateNamespace(mainDescription, manifest);
            });
        }).collect(Collectors.toList());
        mainDescription.setManifests(updatedManifestList);
        return mainDescription;
    }

    private KubernetesManifest updateNamespace(KubernetesDeployManifestDescription description, KubernetesManifest manifest) {
        KubernetesCredentials credentials = description.getCredentials().getCredentials();
        if (!StringUtils.isBlank((CharSequence)description.getNamespaceOverride()) && credentials.getKindProperties(manifest.getKind()).isNamespaced()) {
            manifest.setNamespace(description.getNamespaceOverride());
        }
        return manifest;
    }
}

