/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.GlobalResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.ResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
public class AccountResourcePropertyRegistry
implements ResourcePropertyRegistry {
    private final GlobalResourcePropertyRegistry globalResourcePropertyRegistry;
    private final ImmutableMap<KubernetesKind, KubernetesResourceProperties> propertyMap;

    private AccountResourcePropertyRegistry(GlobalResourcePropertyRegistry globalResourcePropertyRegistry, Collection<KubernetesResourceProperties> resourceProperties) {
        this.globalResourcePropertyRegistry = globalResourcePropertyRegistry;
        this.propertyMap = (ImmutableMap)resourceProperties.stream().collect(ImmutableMap.toImmutableMap(p -> p.getHandler().kind(), Function.identity()));
    }

    @Override
    @Nonnull
    public KubernetesResourceProperties get(KubernetesKind kind) {
        KubernetesResourceProperties accountResult = (KubernetesResourceProperties)this.propertyMap.get((Object)kind);
        if (accountResult != null) {
            return accountResult;
        }
        return this.globalResourcePropertyRegistry.get(kind);
    }

    @Override
    @Nonnull
    public ImmutableCollection<KubernetesResourceProperties> values() {
        return new ImmutableList.Builder().addAll(this.globalResourcePropertyRegistry.values()).addAll((Iterable)this.propertyMap.values()).build();
    }

    @Component
    public static class Factory {
        private final GlobalResourcePropertyRegistry globalResourcePropertyRegistry;

        public Factory(GlobalResourcePropertyRegistry globalResourcePropertyRegistry) {
            this.globalResourcePropertyRegistry = globalResourcePropertyRegistry;
        }

        public AccountResourcePropertyRegistry create(Collection<KubernetesResourceProperties> resourceProperties) {
            return new AccountResourcePropertyRegistry(this.globalResourcePropertyRegistry, resourceProperties);
        }
    }
}

