/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class KubernetesSpinnakerKindMap {
    private final ImmutableMap<KubernetesKind, SpinnakerKind> kubernetesToSpinnaker;
    private final ImmutableSetMultimap<SpinnakerKind, KubernetesKind> spinnakerToKubernetes;

    public KubernetesSpinnakerKindMap(List<KubernetesHandler> handlers) {
        ImmutableMap.Builder kubernetesToSpinnakerBuilder = new ImmutableMap.Builder();
        ImmutableSetMultimap.Builder spinnakerToKubernetesBuilder = new ImmutableSetMultimap.Builder();
        for (KubernetesHandler handler : handlers) {
            SpinnakerKind spinnakerKind = handler.spinnakerKind();
            KubernetesKind kubernetesKind = handler.kind();
            kubernetesToSpinnakerBuilder.put((Object)kubernetesKind, (Object)spinnakerKind);
            spinnakerToKubernetesBuilder.put((Object)spinnakerKind, (Object)kubernetesKind);
        }
        this.kubernetesToSpinnaker = kubernetesToSpinnakerBuilder.build();
        this.spinnakerToKubernetes = spinnakerToKubernetesBuilder.build();
    }

    public SpinnakerKind translateKubernetesKind(KubernetesKind kubernetesKind) {
        return (SpinnakerKind)((Object)this.kubernetesToSpinnaker.getOrDefault((Object)kubernetesKind, (Object)SpinnakerKind.UNCLASSIFIED));
    }

    public ImmutableSet<KubernetesKind> translateSpinnakerKind(SpinnakerKind spinnakerKind) {
        return this.spinnakerToKubernetes.get((Object)spinnakerKind);
    }

    public ImmutableSet<KubernetesKind> allKubernetesKinds() {
        return this.kubernetesToSpinnaker.keySet();
    }

    public Map<String, String> kubernetesToSpinnakerKindStringMap() {
        return this.kubernetesToSpinnaker.entrySet().stream().filter(x -> !((KubernetesKind)x.getKey()).equals(KubernetesKind.NONE)).collect(Collectors.toMap(x -> ((KubernetesKind)x.getKey()).toString(), x -> ((SpinnakerKind)((Object)((Object)x.getValue()))).toString()));
    }
}

