/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description.manifest;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApplicationProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Map;

public class KubernetesManifestLabeler {
    private static final String SPINNAKER_LABEL = "spinnaker.io";
    private static final String MONIKER_LABEL_PREFIX = "moniker.spinnaker.io";
    private static final String SEQUENCE = "moniker.spinnaker.io/sequence";
    private static final String KUBERNETES_LABEL = "kubernetes.io";
    private static final String APP_LABEL_PREFIX = "app.kubernetes.io";
    private static final String APP_NAME = "app.kubernetes.io/name";
    private static final String APP_VERSION = "app.kubernetes.io/version";
    private static final String APP_COMPONENT = "app.kubernetes.io/component";
    private static final String APP_PART_OF = "app.kubernetes.io/part-of";
    private static final String APP_MANAGED_BY = "app.kubernetes.io/managed-by";

    private static void storeLabelAndOverwrite(Map<String, String> labels, String key, String value) {
        if (value == null) {
            return;
        }
        labels.put(key, value);
    }

    private static void storeLabel(Map<String, String> labels, String key, String value) {
        if (value == null) {
            return;
        }
        if (labels.containsKey(key)) {
            return;
        }
        labels.put(key, value);
    }

    public static void labelManifest(String managedBySuffix, KubernetesManifest manifest, Moniker moniker, Boolean skipSpecTemplateLabels) {
        Map<String, String> labels = manifest.getLabels();
        KubernetesManifestLabeler.storeLabels(managedBySuffix, labels, moniker);
        if (!skipSpecTemplateLabels.booleanValue()) {
            manifest.getSpecTemplateLabels().ifPresent(l -> KubernetesManifestLabeler.storeLabels(managedBySuffix, l, moniker));
        }
    }

    public static void storeLabels(String managedBySuffix, Map<String, String> labels, Moniker moniker) {
        if (moniker == null) {
            return;
        }
        Object appManagedByValue = "spinnaker";
        if (!Strings.isNullOrEmpty((String)managedBySuffix)) {
            appManagedByValue = (String)appManagedByValue + "-" + managedBySuffix;
        }
        KubernetesManifestLabeler.storeLabel(labels, APP_NAME, moniker.getApp());
        KubernetesManifestLabeler.storeLabelAndOverwrite(labels, APP_MANAGED_BY, (String)appManagedByValue);
        if (moniker.getSequence() != null) {
            KubernetesManifestLabeler.storeLabelAndOverwrite(labels, SEQUENCE, "" + moniker.getSequence());
        }
    }

    public static KubernetesApplicationProperties getApplicationProperties(KubernetesManifest manifest) {
        Map<String, String> labels = manifest.getLabels();
        return new KubernetesApplicationProperties().setName(labels.get(APP_NAME)).setVersion(labels.get(APP_VERSION)).setComponent(labels.get(APP_COMPONENT)).setPartOf(labels.get(APP_PART_OF)).setManagedBy(labels.get(APP_MANAGED_BY));
    }
}

