/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.health;

import com.google.common.collect.ImmutableList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.core.AccountHealthIndicator;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesConfigurationProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class KubernetesHealthIndicator
extends AccountHealthIndicator<KubernetesNamedAccountCredentials> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesHealthIndicator.class);
    private static final String ID = "kubernetes";
    private final CredentialsRepository<KubernetesNamedAccountCredentials> credentialsRepository;
    private final KubernetesConfigurationProperties kubernetesConfigurationProperties;

    @Autowired
    public KubernetesHealthIndicator(Registry registry, CredentialsRepository<KubernetesNamedAccountCredentials> credentialsRepository, KubernetesConfigurationProperties kubernetesConfigurationProperties) {
        super(ID, registry);
        this.credentialsRepository = credentialsRepository;
        this.kubernetesConfigurationProperties = kubernetesConfigurationProperties;
        if (kubernetesConfigurationProperties.isVerifyAccountHealth()) {
            log.info("kubernetes.verifyAccountHealth flag is enabled - declared namespaces will be retrieved for all accounts");
        } else {
            log.warn("kubernetes.verifyAccountHealth flag is disabled - declared namespaces will not be retrieved for any account");
        }
    }

    protected ImmutableList<KubernetesNamedAccountCredentials> getAccounts() {
        return ImmutableList.copyOf((Collection)this.credentialsRepository.getAll());
    }

    protected Optional<String> accountHealth(KubernetesNamedAccountCredentials accountCredentials) {
        if (this.kubernetesConfigurationProperties.isVerifyAccountHealth()) {
            try {
                accountCredentials.getCredentials().getDeclaredNamespaces();
            }
            catch (RuntimeException e) {
                return Optional.of(e.getMessage());
            }
        }
        return Optional.empty();
    }
}

