/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.names;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.names.NamingStrategy;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@NonnullByDefault
public class KubernetesNamerRegistry {
    private final ImmutableMap<String, NamingStrategy<KubernetesManifest>> strategies;

    @Autowired
    public KubernetesNamerRegistry(List<NamingStrategy<KubernetesManifest>> strategies) {
        this.strategies = (ImmutableMap)strategies.stream().collect(ImmutableMap.toImmutableMap(s -> s.getName().toLowerCase(), s -> s));
    }

    public NamingStrategy<KubernetesManifest> get(String name) {
        return Optional.ofNullable((NamingStrategy)this.strategies.get((Object)name.toLowerCase())).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find naming strategy '%s'", name)));
    }
}

