/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.ResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface CanLoadBalance {
    public void attach(KubernetesManifest var1, KubernetesManifest var2);

    public List<JsonPatch> detachPatch(KubernetesManifest var1, KubernetesManifest var2);

    public List<JsonPatch> attachPatch(KubernetesManifest var1, KubernetesManifest var2);

    public static CanLoadBalance lookupProperties(ResourcePropertyRegistry registry, KubernetesCoordinates coords) {
        KubernetesHandler loadBalancerHandler = registry.get(coords.getKind()).getHandler();
        if (!(loadBalancerHandler instanceof CanLoadBalance)) {
            throw new IllegalArgumentException("No support for load balancing via " + String.valueOf(coords.getKind()) + " exists in Spinnaker");
        }
        return (CanLoadBalance)((Object)loadBalancerHandler);
    }
}

