/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import io.kubernetes.client.openapi.models.V1HorizontalPodAutoscaler;
import io.kubernetes.client.openapi.models.V1HorizontalPodAutoscalerStatus;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
public class KubernetesHorizontalPodAutoscalerHandler
extends KubernetesHandler {
    @Override
    @Nonnull
    protected ImmutableList<Replacer> artifactReplacers() {
        return ImmutableList.of((Object)Replacer.hpaDeployment(), (Object)Replacer.hpaReplicaSet());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_ATTACHMENT_PRIORITY.getValue();
    }

    @Override
    @Nonnull
    public KubernetesKind kind() {
        return KubernetesKind.HORIZONTAL_POD_AUTOSCALER;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    @Nonnull
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.UNCLASSIFIED;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        V1HorizontalPodAutoscaler hpa = KubernetesCacheDataConverter.getResource(manifest, V1HorizontalPodAutoscaler.class);
        return this.status(hpa);
    }

    private Manifest.Status status(V1HorizontalPodAutoscaler hpa) {
        int existing;
        V1HorizontalPodAutoscalerStatus status = hpa.getStatus();
        if (status == null) {
            return Manifest.Status.noneReported();
        }
        int desiredReplicas = KubernetesHorizontalPodAutoscalerHandler.defaultToZero(status.getDesiredReplicas());
        if (desiredReplicas > (existing = KubernetesHorizontalPodAutoscalerHandler.defaultToZero(status.getCurrentReplicas()))) {
            return Manifest.Status.defaultStatus().unstable(String.format("Waiting for HPA to complete a scale up, current: %d desired: %d", existing, desiredReplicas));
        }
        if (desiredReplicas < existing) {
            return Manifest.Status.defaultStatus().unstable(String.format("Waiting for HPA to complete a scale down, current: %d desired: %d", existing, desiredReplicas));
        }
        return Manifest.Status.defaultStatus();
    }

    private static int defaultToZero(@Nullable Integer input) {
        return input == null ? 0 : input;
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }
}

