/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class KubernetesSecretHandler
extends KubernetesHandler {
    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.MOUNTABLE_DATA_PRIORITY.getValue();
    }

    @Override
    @Nonnull
    public KubernetesKind kind() {
        return KubernetesKind.SECRET;
    }

    @Override
    public List<String> sensitiveKeys() {
        return ImmutableList.of((Object)"data");
    }

    @Override
    public boolean versioned() {
        return true;
    }

    @Override
    @Nonnull
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.CONFIGS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        return Manifest.Status.defaultStatus();
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }
}

