/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesDeleteManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDeleteManifestOperation
implements AtomicOperation<OperationResult> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesDeleteManifestOperation.class);
    private final KubernetesDeleteManifestDescription description;
    private final KubernetesCredentials credentials;
    private static final String OP_NAME = "DELETE_KUBERNETES_MANIFEST";

    public KubernetesDeleteManifestOperation(KubernetesDeleteManifestDescription description) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public OperationResult operate(List<OperationResult> priorOutputs) {
        Map<Object, Object> options;
        KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, "Starting delete operation in account " + this.credentials.getAccountName() + "...");
        ImmutableList coordinates = this.description.isDynamic() ? this.description.getAllCoordinates() : ImmutableList.of((Object)this.description.getPointCoordinates());
        V1DeleteOptions deleteOptions = new V1DeleteOptions();
        Map<Object, Object> map = options = this.description.getOptions() == null ? new HashMap() : this.description.getOptions();
        if (options.containsKey("orphanDependents")) {
            deleteOptions.setPropagationPolicy(((String)options.get("orphanDependents")).equalsIgnoreCase("true") ? "orphan" : "background");
        } else if (options.containsKey("cascading")) {
            String propagationPolicy = null;
            propagationPolicy = ((String)options.get("cascading")).equalsIgnoreCase("false") ? "orphan" : (((String)options.get("cascading")).equalsIgnoreCase("true") ? "background" : (String)options.get("cascading"));
            deleteOptions.setPropagationPolicy(propagationPolicy);
        }
        if (options.containsKey("gracePeriodSeconds")) {
            try {
                deleteOptions.setGracePeriodSeconds(Long.valueOf(Long.parseLong((String)options.get("gracePeriodSeconds"))));
            }
            catch (NumberFormatException nfe) {
                log.warn("Unable to parse gracePeriodSeconds; {}", (Object)nfe.getMessage());
            }
        }
        OperationResult result = new OperationResult();
        coordinates.forEach(c -> {
            KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties for " + String.valueOf(c.getKind()) + "...");
            KubernetesHandler deployer = this.credentials.getResourcePropertyRegistry().get(c.getKind()).getHandler();
            KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, "Calling delete operation for resource" + String.valueOf(c) + "...");
            result.merge(deployer.delete(this.credentials, c.getNamespace(), c.getName(), this.description.getLabelSelectors(), deleteOptions, KubernetesDeleteManifestOperation.getTask(), OP_NAME));
            KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, " delete operation completed successfully for " + c.getName());
        });
        KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, " delete operation completed successfully for all applicable resources");
        return result;
    }
}

