/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.provider;

import com.netflix.spinnaker.clouddriver.model.HealthState;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KubernetesModelUtil {
    public static HealthState getHealthState(List<Map<String, Object>> health) {
        return KubernetesModelUtil.someUpRemainingUnknown(health) ? HealthState.Up : (KubernetesModelUtil.someSucceededRemainingUnknown(health) ? HealthState.Succeeded : (KubernetesModelUtil.anyStarting(health) ? HealthState.Starting : (KubernetesModelUtil.anyDown(health) ? HealthState.Down : (KubernetesModelUtil.anyFailed(health) ? HealthState.Failed : (KubernetesModelUtil.anyOutOfService(health) ? HealthState.OutOfService : HealthState.Unknown)))));
    }

    private static boolean stateEquals(Map<String, Object> health, HealthState state) {
        Object healthState = health.get("state");
        return healthState != null && healthState.equals(state.name());
    }

    private static boolean someUpRemainingUnknown(List<Map<String, Object>> healthsList) {
        List knownHealthList = healthsList.stream().filter(h -> !KubernetesModelUtil.stateEquals(h, HealthState.Unknown)).collect(Collectors.toList());
        return !knownHealthList.isEmpty() && knownHealthList.stream().allMatch(h -> KubernetesModelUtil.stateEquals(h, HealthState.Up));
    }

    private static boolean someSucceededRemainingUnknown(List<Map<String, Object>> healthsList) {
        List knownHealthList = healthsList.stream().filter(h -> !KubernetesModelUtil.stateEquals(h, HealthState.Unknown)).collect(Collectors.toList());
        return !knownHealthList.isEmpty() && knownHealthList.stream().allMatch(h -> KubernetesModelUtil.stateEquals(h, HealthState.Succeeded));
    }

    private static boolean anyDown(List<Map<String, Object>> healthsList) {
        return healthsList.stream().anyMatch(h -> KubernetesModelUtil.stateEquals(h, HealthState.Down));
    }

    private static boolean anyStarting(List<Map<String, Object>> healthsList) {
        return healthsList.stream().anyMatch(h -> KubernetesModelUtil.stateEquals(h, HealthState.Starting));
    }

    private static boolean anyFailed(List<Map<String, Object>> healthsList) {
        return healthsList.stream().anyMatch(h -> KubernetesModelUtil.stateEquals(h, HealthState.Failed));
    }

    private static boolean anyOutOfService(List<Map<String, Object>> healthsList) {
        return healthsList.stream().anyMatch(h -> KubernetesModelUtil.stateEquals(h, HealthState.OutOfService));
    }
}

