/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesAccountProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.credentials.definition.CredentialsParser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KubernetesCredentialsParser
implements CredentialsParser<KubernetesAccountProperties.ManagedAccount, KubernetesNamedAccountCredentials> {
    @Generated
    private static final Logger log = LogManager.getLogger(KubernetesCredentialsParser.class);
    private final KubernetesCredentials.Factory credentialFactory;

    @Nullable
    public KubernetesNamedAccountCredentials parse(@Nonnull KubernetesAccountProperties.ManagedAccount managedAccount) {
        try {
            return new KubernetesNamedAccountCredentials(managedAccount, this.credentialFactory);
        }
        catch (RuntimeException e) {
            log.warn("Skipping invalid account definition account={}", (Object)managedAccount.getName(), (Object)e);
            return null;
        }
    }

    @Generated
    public KubernetesCredentialsParser(KubernetesCredentials.Factory credentialFactory) {
        this.credentialFactory = credentialFactory;
    }
}

