/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesAccountProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.config.LinkedDockerRegistryConfiguration;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.security.AbstractAccountCredentials;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;

@ParametersAreNonnullByDefault
public class KubernetesNamedAccountCredentials
extends AbstractAccountCredentials<KubernetesCredentials> {
    private final String cloudProvider = "kubernetes";
    @Nonnull
    private final String name;
    private final String environment;
    private final String accountType;
    private final int cacheThreads;
    private final KubernetesCredentials credentials;
    private final List<String> requiredGroupMembership;
    private final Permissions permissions;
    private final Long cacheIntervalSeconds;

    public KubernetesNamedAccountCredentials(KubernetesAccountProperties.ManagedAccount managedAccount, KubernetesCredentials.Factory credentialFactory) {
        managedAccount.validate();
        this.name = Objects.requireNonNull(managedAccount.getName());
        this.environment = Optional.ofNullable(managedAccount.getEnvironment()).orElse(managedAccount.getName());
        this.accountType = Optional.ofNullable(managedAccount.getAccountType()).orElse(managedAccount.getName());
        this.cacheThreads = managedAccount.getCacheThreads();
        this.cacheIntervalSeconds = managedAccount.getCacheIntervalSeconds();
        Permissions permissions = managedAccount.getPermissions().build();
        if (permissions.isRestricted()) {
            this.permissions = permissions;
            this.requiredGroupMembership = Collections.emptyList();
        } else {
            this.permissions = null;
            this.requiredGroupMembership = Collections.unmodifiableList(managedAccount.getRequiredGroupMembership());
        }
        this.credentials = credentialFactory.build(managedAccount);
    }

    public List<String> getRequiredGroupMembership() {
        return this.requiredGroupMembership;
    }

    public List<String> getNamespaces() {
        return this.credentials.getDeclaredNamespacesFromCache();
    }

    public Map<String, String> getSpinnakerKindMap() {
        return this.credentials.getSpinnakerKindMap();
    }

    public List<LinkedDockerRegistryConfiguration> getDockerRegistries() {
        return this.credentials.getDockerRegistries();
    }

    @Generated
    public String getCloudProvider() {
        return this.cloudProvider;
    }

    @Nonnull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public String getAccountType() {
        return this.accountType;
    }

    @Generated
    public int getCacheThreads() {
        return this.cacheThreads;
    }

    @Generated
    public KubernetesCredentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Generated
    public Long getCacheIntervalSeconds() {
        return this.cacheIntervalSeconds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesNamedAccountCredentials)) {
            return false;
        }
        KubernetesNamedAccountCredentials other = (KubernetesNamedAccountCredentials)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCacheThreads() != other.getCacheThreads()) {
            return false;
        }
        Long this$cacheIntervalSeconds = this.getCacheIntervalSeconds();
        Long other$cacheIntervalSeconds = other.getCacheIntervalSeconds();
        if (this$cacheIntervalSeconds == null ? other$cacheIntervalSeconds != null : !((Object)this$cacheIntervalSeconds).equals(other$cacheIntervalSeconds)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$accountType = this.getAccountType();
        String other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
            return false;
        }
        KubernetesCredentials this$credentials = this.getCredentials();
        KubernetesCredentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        List<String> this$requiredGroupMembership = this.getRequiredGroupMembership();
        List<String> other$requiredGroupMembership = other.getRequiredGroupMembership();
        if (this$requiredGroupMembership == null ? other$requiredGroupMembership != null : !((Object)this$requiredGroupMembership).equals(other$requiredGroupMembership)) {
            return false;
        }
        Permissions this$permissions = this.getPermissions();
        Permissions other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesNamedAccountCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCacheThreads();
        Long $cacheIntervalSeconds = this.getCacheIntervalSeconds();
        result = result * 59 + ($cacheIntervalSeconds == null ? 43 : ((Object)$cacheIntervalSeconds).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
        KubernetesCredentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        List<String> $requiredGroupMembership = this.getRequiredGroupMembership();
        result = result * 59 + ($requiredGroupMembership == null ? 43 : ((Object)$requiredGroupMembership).hashCode());
        Permissions $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : $permissions.hashCode());
        return result;
    }
}

