/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.validator;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesValidationUtil {
    private static final Logger log = LoggerFactory.getLogger(KubernetesValidationUtil.class);
    private final String context;
    private final ValidationErrors errors;

    public KubernetesValidationUtil(String context, ValidationErrors errors) {
        this.context = context;
        this.errors = errors;
    }

    private String joinAttributeChain(String ... attributes) {
        ArrayList<String> chain = new ArrayList<String>();
        chain.add(this.context);
        Collections.addAll(chain, attributes);
        return String.join((CharSequence)".", chain);
    }

    public void reject(String errorName, String ... attributes) {
        String field = this.joinAttributeChain(attributes);
        String error = this.joinAttributeChain(field, errorName);
        this.errors.reject(field, error);
    }

    public boolean validateNotEmpty(String attribute, Object value) {
        if (value == null) {
            this.reject("empty", attribute);
            return false;
        }
        return true;
    }

    public boolean validateCredentials(AccountCredentialsProvider provider, String accountName, KubernetesManifest manifest) {
        String namespace = manifest.getNamespace();
        return this.validateCredentials(provider, accountName, namespace);
    }

    public boolean validateCredentials(AccountCredentialsProvider provider, String accountName, String namespace) {
        log.info("Validating credentials for {} {}", (Object)accountName, (Object)namespace);
        if (Strings.isNullOrEmpty((String)accountName)) {
            this.reject("empty", "account");
            return false;
        }
        if (Strings.isNullOrEmpty((String)namespace)) {
            return true;
        }
        AccountCredentials credentials = provider.getCredentials(accountName);
        if (credentials == null) {
            this.reject("notFound", "account");
            return false;
        }
        if (!(credentials.getCredentials() instanceof KubernetesCredentials)) {
            this.reject("wrongVersion", "account");
            return false;
        }
        return this.validateNamespace(namespace, (KubernetesCredentials)credentials.getCredentials());
    }

    protected boolean validateNamespace(String namespace, KubernetesCredentials credentials) {
        ImmutableList<String> configuredNamespaces = credentials.getNamespaces();
        if (configuredNamespaces != null && !configuredNamespaces.isEmpty() && !configuredNamespaces.contains(namespace)) {
            this.reject("wrongNamespace", namespace);
            return false;
        }
        ImmutableList<String> omitNamespaces = credentials.getOmitNamespaces();
        if (omitNamespaces != null && omitNamespaces.contains(namespace)) {
            this.reject("omittedNamespace", namespace);
            return false;
        }
        return true;
    }
}

