/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.validator.servergroup;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.description.servergroup.KubernetesResizeServerGroupDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.validator.KubernetesValidationUtil;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@KubernetesOperation(value="resizeServerGroup")
@Component
public class KubernetesResizeServerGroupValidator
extends DescriptionValidator<KubernetesResizeServerGroupDescription> {
    @Autowired
    AccountCredentialsProvider provider;

    public void validate(List<KubernetesResizeServerGroupDescription> priorDescriptions, KubernetesResizeServerGroupDescription description, ValidationErrors errors) {
        KubernetesValidationUtil util = new KubernetesValidationUtil("deployKubernetesManifest", errors);
        if (!util.validateCredentials(this.provider, description.getAccount(), description.getCoordinates().getNamespace())) {
            return;
        }
        util.validateNotEmpty("capacity", description.getCapacity());
    }
}

