/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.ResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesCachingAgentDispatcher {
    private final ObjectMapper objectMapper;
    private final Registry registry;

    @Autowired
    public KubernetesCachingAgentDispatcher(ObjectMapper objectMapper, Registry registry) {
        this.objectMapper = objectMapper;
        this.registry = registry;
    }

    public Collection<KubernetesCachingAgent> buildAllCachingAgents(KubernetesNamedAccountCredentials credentials) {
        KubernetesCredentials kubernetesCredentials = credentials.getCredentials();
        ArrayList result = new ArrayList();
        Long agentInterval = Optional.ofNullable(credentials.getCacheIntervalSeconds()).map(TimeUnit.SECONDS::toMillis).orElse(null);
        ResourcePropertyRegistry propertyRegistry = kubernetesCredentials.getResourcePropertyRegistry();
        IntStream.range(0, credentials.getCacheThreads()).forEach(i -> propertyRegistry.values().stream().map(KubernetesResourceProperties::getHandler).map(h -> h.buildCachingAgent(credentials, this.objectMapper, this.registry, i, credentials.getCacheThreads(), agentInterval)).filter(Objects::nonNull).forEach(result::add));
        return result.stream().collect(Collectors.toMap(KubernetesCachingAgent::getAgentType, c -> c, (a, b) -> b)).values();
    }
}

