/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesLoadBalancer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesServerGroup;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.data.KubernetesServerGroupCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesLoadBalancerProvider
implements LoadBalancerProvider<KubernetesLoadBalancer> {
    private final KubernetesCacheUtils cacheUtils;

    @Autowired
    KubernetesLoadBalancerProvider(KubernetesCacheUtils cacheUtils) {
        this.cacheUtils = cacheUtils;
    }

    public String getCloudProvider() {
        return "kubernetes";
    }

    public List<LoadBalancerProvider.Item> list() {
        return new ArrayList<LoadBalancerProvider.Item>();
    }

    public LoadBalancerProvider.Item get(String name) {
        throw new NotImplementedException("Not a valid operation");
    }

    public List<KubernetesLoadBalancer> byAccountAndRegionAndName(String account, String namespace, String fullName) {
        return this.cacheUtils.getSingleEntry(account, namespace, fullName).map(loadBalancerData -> this.fromLoadBalancerCacheData((Collection<CacheData>)ImmutableList.of((Object)loadBalancerData))).map(ImmutableList::copyOf).orElse(null);
    }

    public Set<KubernetesLoadBalancer> getApplicationLoadBalancers(String application) {
        return this.cacheUtils.getSingleEntry(Keys.LogicalKind.APPLICATIONS.toString(), Keys.ApplicationCacheKey.createKey(application)).map(applicationData -> this.fromLoadBalancerCacheData((Collection<CacheData>)this.cacheUtils.getRelationships((CacheData)applicationData, SpinnakerKind.LOAD_BALANCERS))).orElseGet(ImmutableSet::of);
    }

    private Set<KubernetesLoadBalancer> fromLoadBalancerCacheData(Collection<CacheData> loadBalancerData) {
        ImmutableMultimap<String, CacheData> loadBalancerToServerGroups = this.cacheUtils.getRelationships(loadBalancerData, SpinnakerKind.SERVER_GROUPS);
        ImmutableMultimap<String, CacheData> serverGroupToInstances = this.cacheUtils.getRelationships((Collection<CacheData>)loadBalancerToServerGroups.values(), SpinnakerKind.INSTANCES);
        return loadBalancerData.stream().map(lb -> KubernetesLoadBalancer.fromCacheData(lb, (Set)loadBalancerToServerGroups.get((Object)lb.getId()).stream().map(sg -> KubernetesServerGroup.fromCacheData(KubernetesServerGroupCacheData.builder().serverGroupData((CacheData)sg).instanceData((Collection<CacheData>)serverGroupToInstances.get((Object)sg.getId())).loadBalancerKeys((Collection<String>)ImmutableList.of((Object)lb.getId())).build())).filter(Objects::nonNull).map(KubernetesServerGroup::toLoadBalancerServerGroup).collect(ImmutableSet.toImmutableSet()))).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

