/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.data;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.data.KubernetesCacheData;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;

@NonnullByDefault
public final class KubernetesServerGroupCacheData
implements KubernetesCacheData {
    private final CacheData serverGroupData;
    private final Collection<CacheData> instanceData;
    private final Collection<String> loadBalancerKeys;
    private final Collection<String> serverGroupManagerKeys;

    @ParametersAreNullableByDefault
    private KubernetesServerGroupCacheData(@Nonnull CacheData serverGroupData, Collection<CacheData> instanceData, Collection<String> loadBalancerKeys, Collection<String> serverGroupManagerKeys) {
        this.serverGroupData = Objects.requireNonNull(serverGroupData);
        this.instanceData = Optional.ofNullable(instanceData).orElseGet(ImmutableList::of);
        this.loadBalancerKeys = Optional.ofNullable(loadBalancerKeys).orElseGet(ImmutableList::of);
        this.serverGroupManagerKeys = Optional.ofNullable(serverGroupManagerKeys).orElseGet(ImmutableList::of);
    }

    @Override
    public CacheData primaryData() {
        return this.serverGroupData;
    }

    @Generated
    public static KubernetesServerGroupCacheDataBuilder builder() {
        return new KubernetesServerGroupCacheDataBuilder();
    }

    @Generated
    public CacheData getServerGroupData() {
        return this.serverGroupData;
    }

    @Generated
    public Collection<CacheData> getInstanceData() {
        return this.instanceData;
    }

    @Generated
    public Collection<String> getLoadBalancerKeys() {
        return this.loadBalancerKeys;
    }

    @Generated
    public Collection<String> getServerGroupManagerKeys() {
        return this.serverGroupManagerKeys;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesServerGroupCacheData)) {
            return false;
        }
        KubernetesServerGroupCacheData other = (KubernetesServerGroupCacheData)o;
        CacheData this$serverGroupData = this.getServerGroupData();
        CacheData other$serverGroupData = other.getServerGroupData();
        if (this$serverGroupData == null ? other$serverGroupData != null : !this$serverGroupData.equals(other$serverGroupData)) {
            return false;
        }
        Collection<CacheData> this$instanceData = this.getInstanceData();
        Collection<CacheData> other$instanceData = other.getInstanceData();
        if (this$instanceData == null ? other$instanceData != null : !((Object)this$instanceData).equals(other$instanceData)) {
            return false;
        }
        Collection<String> this$loadBalancerKeys = this.getLoadBalancerKeys();
        Collection<String> other$loadBalancerKeys = other.getLoadBalancerKeys();
        if (this$loadBalancerKeys == null ? other$loadBalancerKeys != null : !((Object)this$loadBalancerKeys).equals(other$loadBalancerKeys)) {
            return false;
        }
        Collection<String> this$serverGroupManagerKeys = this.getServerGroupManagerKeys();
        Collection<String> other$serverGroupManagerKeys = other.getServerGroupManagerKeys();
        return !(this$serverGroupManagerKeys == null ? other$serverGroupManagerKeys != null : !((Object)this$serverGroupManagerKeys).equals(other$serverGroupManagerKeys));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CacheData $serverGroupData = this.getServerGroupData();
        result = result * 59 + ($serverGroupData == null ? 43 : $serverGroupData.hashCode());
        Collection<CacheData> $instanceData = this.getInstanceData();
        result = result * 59 + ($instanceData == null ? 43 : ((Object)$instanceData).hashCode());
        Collection<String> $loadBalancerKeys = this.getLoadBalancerKeys();
        result = result * 59 + ($loadBalancerKeys == null ? 43 : ((Object)$loadBalancerKeys).hashCode());
        Collection<String> $serverGroupManagerKeys = this.getServerGroupManagerKeys();
        result = result * 59 + ($serverGroupManagerKeys == null ? 43 : ((Object)$serverGroupManagerKeys).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesServerGroupCacheData(serverGroupData=" + this.getServerGroupData() + ", instanceData=" + this.getInstanceData() + ", loadBalancerKeys=" + this.getLoadBalancerKeys() + ", serverGroupManagerKeys=" + this.getServerGroupManagerKeys() + ")";
    }

    @Generated
    public static class KubernetesServerGroupCacheDataBuilder {
        @Generated
        private CacheData serverGroupData;
        @Generated
        private Collection<CacheData> instanceData;
        @Generated
        private Collection<String> loadBalancerKeys;
        @Generated
        private Collection<String> serverGroupManagerKeys;

        @Generated
        KubernetesServerGroupCacheDataBuilder() {
        }

        @Generated
        public KubernetesServerGroupCacheDataBuilder serverGroupData(@Nonnull CacheData serverGroupData) {
            this.serverGroupData = serverGroupData;
            return this;
        }

        @Generated
        public KubernetesServerGroupCacheDataBuilder instanceData(Collection<CacheData> instanceData) {
            this.instanceData = instanceData;
            return this;
        }

        @Generated
        public KubernetesServerGroupCacheDataBuilder loadBalancerKeys(Collection<String> loadBalancerKeys) {
            this.loadBalancerKeys = loadBalancerKeys;
            return this;
        }

        @Generated
        public KubernetesServerGroupCacheDataBuilder serverGroupManagerKeys(Collection<String> serverGroupManagerKeys) {
            this.serverGroupManagerKeys = serverGroupManagerKeys;
            return this;
        }

        @Generated
        public KubernetesServerGroupCacheData build() {
            return new KubernetesServerGroupCacheData(this.serverGroupData, this.instanceData, this.loadBalancerKeys, this.serverGroupManagerKeys);
        }

        @Generated
        public String toString() {
            return "KubernetesServerGroupCacheData.KubernetesServerGroupCacheDataBuilder(serverGroupData=" + this.serverGroupData + ", instanceData=" + this.instanceData + ", loadBalancerKeys=" + this.loadBalancerKeys + ", serverGroupManagerKeys=" + this.serverGroupManagerKeys + ")";
        }
    }
}

