/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;

public enum SpinnakerKind {
    INSTANCES("instances"),
    CONFIGS("configs"),
    SERVER_GROUPS("serverGroups"),
    LOAD_BALANCERS("loadBalancers"),
    SECURITY_GROUPS("securityGroups"),
    SERVER_GROUP_MANAGERS("serverGroupManagers"),
    UNCLASSIFIED("unclassified");

    private final String id;

    private SpinnakerKind(String id) {
        this.id = id;
    }

    public String toString() {
        return this.id;
    }

    @JsonCreator
    public static SpinnakerKind fromString(String name) {
        return Arrays.stream(SpinnakerKind.values()).filter(k -> k.toString().equalsIgnoreCase(name)).findFirst().orElse(UNCLASSIFIED);
    }
}

