/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description.manifest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesAtomicOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesSelectorList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class KubernetesDeleteManifestDescription
extends KubernetesAtomicOperationDescription {
    private Map<String, String> options;
    private String manifestName;
    private String location;
    private List<String> kinds = new ArrayList<String>();
    private KubernetesSelectorList labelSelectors = new KubernetesSelectorList();

    @JsonIgnore
    public boolean isDynamic() {
        return Strings.isNullOrEmpty((String)this.manifestName);
    }

    public List<KubernetesCoordinates> getAllCoordinates() {
        return this.kinds.stream().map(k -> KubernetesCoordinates.builder().namespace(this.location).kind(KubernetesKind.fromString(k)).build()).collect(Collectors.toList());
    }

    @JsonIgnore
    public KubernetesCoordinates getPointCoordinates() {
        return KubernetesCoordinates.builder().namespace(this.location).fullResourceName(this.manifestName).build();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesDeleteManifestDescription)) {
            return false;
        }
        KubernetesDeleteManifestDescription other = (KubernetesDeleteManifestDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$options = this.getOptions();
        Map<String, String> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$manifestName = this.getManifestName();
        String other$manifestName = other.getManifestName();
        if (this$manifestName == null ? other$manifestName != null : !this$manifestName.equals(other$manifestName)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        List<String> this$kinds = this.getKinds();
        List<String> other$kinds = other.getKinds();
        if (this$kinds == null ? other$kinds != null : !((Object)this$kinds).equals(other$kinds)) {
            return false;
        }
        KubernetesSelectorList this$labelSelectors = this.getLabelSelectors();
        KubernetesSelectorList other$labelSelectors = other.getLabelSelectors();
        return !(this$labelSelectors == null ? other$labelSelectors != null : !((Object)this$labelSelectors).equals(other$labelSelectors));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesDeleteManifestDescription;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $manifestName = this.getManifestName();
        result = result * 59 + ($manifestName == null ? 43 : $manifestName.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        List<String> $kinds = this.getKinds();
        result = result * 59 + ($kinds == null ? 43 : ((Object)$kinds).hashCode());
        KubernetesSelectorList $labelSelectors = this.getLabelSelectors();
        result = result * 59 + ($labelSelectors == null ? 43 : ((Object)$labelSelectors).hashCode());
        return result;
    }

    @Generated
    public KubernetesDeleteManifestDescription() {
    }

    @Generated
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Generated
    public String getManifestName() {
        return this.manifestName;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public List<String> getKinds() {
        return this.kinds;
    }

    @Generated
    public KubernetesSelectorList getLabelSelectors() {
        return this.labelSelectors;
    }

    @Generated
    public KubernetesDeleteManifestDescription setOptions(Map<String, String> options) {
        this.options = options;
        return this;
    }

    @Generated
    public KubernetesDeleteManifestDescription setManifestName(String manifestName) {
        this.manifestName = manifestName;
        return this;
    }

    @Generated
    public KubernetesDeleteManifestDescription setLocation(String location) {
        this.location = location;
        return this;
    }

    @Generated
    public KubernetesDeleteManifestDescription setKinds(List<String> kinds) {
        this.kinds = kinds;
        return this;
    }

    @Generated
    public KubernetesDeleteManifestDescription setLabelSelectors(KubernetesSelectorList labelSelectors) {
        this.labelSelectors = labelSelectors;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "KubernetesDeleteManifestDescription(options=" + this.getOptions() + ", manifestName=" + this.getManifestName() + ", location=" + this.getLocation() + ", kinds=" + this.getKinds() + ", labelSelectors=" + this.getLabelSelectors() + ")";
    }
}

