/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description.manifest;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import io.kubernetes.client.openapi.models.V1beta1CustomResourceDefinition;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;

@ParametersAreNonnullByDefault
public class KubernetesKindProperties {
    @Nonnull
    private final KubernetesKind kubernetesKind;
    private final boolean isNamespaced;

    public static List<KubernetesKindProperties> getGlobalKindProperties() {
        return ImmutableList.of((Object)new KubernetesKindProperties(KubernetesKind.API_SERVICE, false), (Object)new KubernetesKindProperties(KubernetesKind.CLUSTER_ROLE, false), (Object)new KubernetesKindProperties(KubernetesKind.CLUSTER_ROLE_BINDING, false), (Object)new KubernetesKindProperties(KubernetesKind.CONFIG_MAP, true), (Object)new KubernetesKindProperties(KubernetesKind.CONTROLLER_REVISION, true), (Object)new KubernetesKindProperties(KubernetesKind.CUSTOM_RESOURCE_DEFINITION, false), (Object)new KubernetesKindProperties(KubernetesKind.CRON_JOB, true), (Object)new KubernetesKindProperties(KubernetesKind.DAEMON_SET, true), (Object)new KubernetesKindProperties(KubernetesKind.DEPLOYMENT, true), (Object)new KubernetesKindProperties(KubernetesKind.EVENT, true), (Object)new KubernetesKindProperties(KubernetesKind.HORIZONTAL_POD_AUTOSCALER, true), (Object)new KubernetesKindProperties(KubernetesKind.INGRESS, true), (Object[])new KubernetesKindProperties[]{new KubernetesKindProperties(KubernetesKind.JOB, true), new KubernetesKindProperties(KubernetesKind.LIMIT_RANGE, true), new KubernetesKindProperties(KubernetesKind.MUTATING_WEBHOOK_CONFIGURATION, false), new KubernetesKindProperties(KubernetesKind.NAMESPACE, false), new KubernetesKindProperties(KubernetesKind.NETWORK_POLICY, true), new KubernetesKindProperties(KubernetesKind.PERSISTENT_VOLUME, false), new KubernetesKindProperties(KubernetesKind.PERSISTENT_VOLUME_CLAIM, true), new KubernetesKindProperties(KubernetesKind.POD, true), new KubernetesKindProperties(KubernetesKind.POD_PRESET, true), new KubernetesKindProperties(KubernetesKind.POD_SECURITY_POLICY, false), new KubernetesKindProperties(KubernetesKind.POD_DISRUPTION_BUDGET, true), new KubernetesKindProperties(KubernetesKind.REPLICA_SET, true), new KubernetesKindProperties(KubernetesKind.ROLE, true), new KubernetesKindProperties(KubernetesKind.ROLE_BINDING, true), new KubernetesKindProperties(KubernetesKind.SECRET, true), new KubernetesKindProperties(KubernetesKind.SERVICE, true), new KubernetesKindProperties(KubernetesKind.SERVICE_ACCOUNT, true), new KubernetesKindProperties(KubernetesKind.STATEFUL_SET, true), new KubernetesKindProperties(KubernetesKind.STORAGE_CLASS, false), new KubernetesKindProperties(KubernetesKind.VALIDATING_WEBHOOK_CONFIGURATION, false), new KubernetesKindProperties(KubernetesKind.NONE, true)});
    }

    private KubernetesKindProperties(KubernetesKind kubernetesKind, boolean isNamespaced) {
        this.kubernetesKind = kubernetesKind;
        this.isNamespaced = isNamespaced;
    }

    @Nonnull
    public static KubernetesKindProperties withDefaultProperties(KubernetesKind kubernetesKind) {
        return new KubernetesKindProperties(kubernetesKind, true);
    }

    @Nonnull
    public static KubernetesKindProperties create(KubernetesKind kubernetesKind, boolean isNamespaced) {
        return new KubernetesKindProperties(kubernetesKind, isNamespaced);
    }

    @Nonnull
    public static KubernetesKindProperties fromCustomResourceDefinition(V1beta1CustomResourceDefinition crd) {
        return KubernetesKindProperties.create(KubernetesKind.fromCustomResourceDefinition(crd), crd.getSpec().getScope().equalsIgnoreCase("namespaced"));
    }

    public ResourceScope getResourceScope() {
        return this.isNamespaced ? ResourceScope.NAMESPACE : ResourceScope.CLUSTER;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesKindProperties)) {
            return false;
        }
        KubernetesKindProperties other = (KubernetesKindProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KubernetesKind this$kubernetesKind = this.getKubernetesKind();
        KubernetesKind other$kubernetesKind = other.getKubernetesKind();
        if (this$kubernetesKind == null ? other$kubernetesKind != null : !((Object)this$kubernetesKind).equals(other$kubernetesKind)) {
            return false;
        }
        return this.isNamespaced() == other.isNamespaced();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesKindProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KubernetesKind $kubernetesKind = this.getKubernetesKind();
        result = result * 59 + ($kubernetesKind == null ? 43 : ((Object)$kubernetesKind).hashCode());
        result = result * 59 + (this.isNamespaced() ? 79 : 97);
        return result;
    }

    @Nonnull
    @Generated
    public KubernetesKind getKubernetesKind() {
        return this.kubernetesKind;
    }

    @Generated
    public boolean isNamespaced() {
        return this.isNamespaced;
    }

    public static enum ResourceScope {
        CLUSTER,
        NAMESPACE;

    }
}

