/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description.manifest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesCachingProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesDeployManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestStrategy;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestTraffic;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesManifestAnnotater {
    private static final Logger log = LoggerFactory.getLogger(KubernetesManifestAnnotater.class);
    static final String SPINNAKER_ANNOTATION = "spinnaker.io";
    private static final String TRAFFIC_ANNOTATION_PREFIX = "traffic.spinnaker.io";
    private static final String ARTIFACT_ANNOTATION_PREFIX = "artifact.spinnaker.io";
    private static final String MONIKER_ANNOTATION_PREFIX = "moniker.spinnaker.io";
    private static final String CACHING_ANNOTATION_PREFIX = "caching.spinnaker.io";
    private static final String CLUSTER = "moniker.spinnaker.io/cluster";
    private static final String APPLICATION = "moniker.spinnaker.io/application";
    private static final String STACK = "moniker.spinnaker.io/stack";
    private static final String DETAIL = "moniker.spinnaker.io/detail";
    private static final String SEQUENCE = "moniker.spinnaker.io/sequence";
    private static final String TYPE = "artifact.spinnaker.io/type";
    private static final String NAME = "artifact.spinnaker.io/name";
    private static final String LOCATION = "artifact.spinnaker.io/location";
    private static final String VERSION = "artifact.spinnaker.io/version";
    private static final String IGNORE_CACHING = "caching.spinnaker.io/ignore";
    private static final String LOAD_BALANCERS = "traffic.spinnaker.io/load-balancers";
    private static final String KUBERNETES_ANNOTATION = "kubernetes.io";
    private static final String KUBECTL_ANNOTATION_PREFIX = "kubectl.kubernetes.io";
    private static final String DEPLOYMENT_ANNOTATION_PREFIX = "deployment.kubernetes.io";
    private static final String DEPLOYMENT_REVISION = "deployment.kubernetes.io/revision";
    private static final String KUBECTL_LAST_APPLIED_CONFIGURATION = "kubectl.kubernetes.io/last-applied-configuration";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private static void storeAnnotation(Map<String, String> annotations, String key, Object value) {
        if (value == null) {
            return;
        }
        if (annotations.containsKey(key)) {
            return;
        }
        try {
            if (value instanceof String) {
                annotations.put(key, (String)value);
            } else {
                annotations.put(key, objectMapper.writeValueAsString(value));
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Illegal annotation value for '" + key + "': " + e);
        }
    }

    private static <T> T getAnnotation(Map<String, String> annotations, String key, TypeReference<T> typeReference) {
        return KubernetesManifestAnnotater.getAnnotation(annotations, key, typeReference, null);
    }

    private static boolean stringTypeReference(TypeReference<?> typeReference) {
        if (typeReference.getType() == null || typeReference.getType().getTypeName() == null) {
            log.warn("Malformed type reference {}", typeReference);
            return false;
        }
        return typeReference.getType().getTypeName().equals(String.class.getName());
    }

    private static boolean looksLikeSerializedString(String value) {
        if (Strings.isNullOrEmpty((String)value) || value.length() == 1) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    private static <T> T getAnnotation(Map<String, String> annotations, String key, TypeReference<T> typeReference, T defaultValue) {
        String value = annotations.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            boolean wantsString = KubernetesManifestAnnotater.stringTypeReference(typeReference);
            if (wantsString && !KubernetesManifestAnnotater.looksLikeSerializedString(value)) {
                return (T)value;
            }
            return (T)objectMapper.readValue(value, typeReference);
        }
        catch (Exception e) {
            log.warn("Illegally annotated resource for '" + key + "': " + e);
            return null;
        }
    }

    public static void annotateManifest(KubernetesManifest manifest, Moniker moniker) {
        Map<String, String> annotations = manifest.getAnnotations();
        KubernetesManifestAnnotater.storeAnnotations(annotations, moniker);
        manifest.getSpecTemplateAnnotations().flatMap(a -> {
            KubernetesManifestAnnotater.storeAnnotations((Map<String, String>)a, moniker);
            return Optional.empty();
        });
    }

    public static void annotateManifest(KubernetesManifest manifest, Artifact artifact) {
        Map<String, String> annotations = manifest.getAnnotations();
        KubernetesManifestAnnotater.storeAnnotations(annotations, artifact);
        manifest.getSpecTemplateAnnotations().flatMap(a -> {
            KubernetesManifestAnnotater.storeAnnotations((Map<String, String>)a, artifact);
            return Optional.empty();
        });
    }

    private static void storeAnnotations(Map<String, String> annotations, Moniker moniker) {
        if (moniker == null) {
            throw new IllegalArgumentException("Every resource deployed via spinnaker must be assigned a moniker");
        }
        KubernetesManifestAnnotater.storeAnnotation(annotations, CLUSTER, moniker.getCluster());
        KubernetesManifestAnnotater.storeAnnotation(annotations, APPLICATION, moniker.getApp());
        KubernetesManifestAnnotater.storeAnnotation(annotations, STACK, moniker.getStack());
        KubernetesManifestAnnotater.storeAnnotation(annotations, DETAIL, moniker.getDetail());
        KubernetesManifestAnnotater.storeAnnotation(annotations, SEQUENCE, moniker.getSequence());
    }

    private static void storeAnnotations(Map<String, String> annotations, Artifact artifact) {
        if (artifact == null) {
            return;
        }
        KubernetesManifestAnnotater.storeAnnotation(annotations, TYPE, artifact.getType());
        KubernetesManifestAnnotater.storeAnnotation(annotations, NAME, artifact.getName());
        KubernetesManifestAnnotater.storeAnnotation(annotations, LOCATION, artifact.getLocation());
        KubernetesManifestAnnotater.storeAnnotation(annotations, VERSION, artifact.getVersion());
    }

    public static Optional<Artifact> getArtifact(KubernetesManifest manifest, String account) {
        Map<String, String> annotations = manifest.getAnnotations();
        String type = KubernetesManifestAnnotater.getAnnotation(annotations, TYPE, new TypeReference<String>(){});
        if (Strings.isNullOrEmpty((String)type)) {
            return Optional.empty();
        }
        KubernetesManifest lastAppliedConfiguration = KubernetesManifestAnnotater.getLastAppliedConfiguration(manifest);
        return Optional.of(Artifact.builder().type(type).name(KubernetesManifestAnnotater.getAnnotation(annotations, NAME, new TypeReference<String>(){})).location(KubernetesManifestAnnotater.getAnnotation(annotations, LOCATION, new TypeReference<String>(){})).version(KubernetesManifestAnnotater.getAnnotation(annotations, VERSION, new TypeReference<String>(){})).putMetadata("lastAppliedConfiguration", (Object)lastAppliedConfiguration).putMetadata("account", (Object)account).build());
    }

    public static Moniker getMoniker(KubernetesManifest manifest) {
        Names parsed = Names.parseName((String)manifest.getName());
        Map<String, String> annotations = manifest.getAnnotations();
        Integer defaultSequence = parsed.getSequence();
        return Moniker.builder().cluster(KubernetesManifestAnnotater.getAnnotation(annotations, CLUSTER, new TypeReference<String>(){}, parsed.getCluster())).app(KubernetesManifestAnnotater.getAnnotation(annotations, APPLICATION, new TypeReference<String>(){}, parsed.getApp())).stack((String)KubernetesManifestAnnotater.getAnnotation(annotations, STACK, new TypeReference<String>(){}, null)).detail((String)KubernetesManifestAnnotater.getAnnotation(annotations, DETAIL, new TypeReference<String>(){}, null)).sequence(KubernetesManifestAnnotater.getAnnotation(annotations, SEQUENCE, new TypeReference<Integer>(){}, manifest.getKind().equals(KubernetesKind.REPLICA_SET) ? KubernetesManifestAnnotater.getAnnotation(annotations, DEPLOYMENT_REVISION, new TypeReference<Integer>(){}, defaultSequence) : defaultSequence)).build();
    }

    @NonnullByDefault
    public static KubernetesManifestTraffic getTraffic(KubernetesManifest manifest) {
        Map<String, String> annotations = manifest.getAnnotations();
        List loadBalancers = KubernetesManifestAnnotater.getAnnotation(annotations, LOAD_BALANCERS, new TypeReference<List<String>>(){}, new ArrayList());
        return new KubernetesManifestTraffic(loadBalancers);
    }

    @NonnullByDefault
    public static void setTraffic(KubernetesManifest manifest, KubernetesManifestTraffic traffic) {
        Map<String, String> annotations = manifest.getAnnotations();
        ImmutableList<String> loadBalancers = traffic.getLoadBalancers();
        if (annotations.containsKey(LOAD_BALANCERS)) {
            KubernetesManifestTraffic currentTraffic = KubernetesManifestAnnotater.getTraffic(manifest);
            if (currentTraffic.getLoadBalancers().equals(loadBalancers)) {
                return;
            }
            throw new RuntimeException(String.format("Manifest already has %s annotation set to %s. Failed attempting to set it to %s.", LOAD_BALANCERS, currentTraffic.getLoadBalancers(), loadBalancers));
        }
        KubernetesManifestAnnotater.storeAnnotation(annotations, LOAD_BALANCERS, loadBalancers);
    }

    public static void validateAnnotationsForRolloutStrategies(KubernetesManifest manifest, KubernetesDeployManifestDescription.Strategy strategy) {
        OptionalInt maxVersionHistory = KubernetesManifestAnnotater.getStrategy(manifest).getMaxVersionHistory();
        if (strategy == KubernetesDeployManifestDescription.Strategy.RED_BLACK && maxVersionHistory.isPresent() && maxVersionHistory.getAsInt() < 2) {
            throw new RuntimeException(String.format("The max version history specified in your manifest conflicts with the behavior of the Red/Black rollout strategy. Please update your %s annotation to a value greater than or equal to 2.", "strategy.spinnaker.io/max-version-history"));
        }
    }

    public static KubernetesCachingProperties getCachingProperties(KubernetesManifest manifest) {
        Map<String, String> annotations = manifest.getAnnotations();
        return KubernetesCachingProperties.builder().ignore(KubernetesManifestAnnotater.getAnnotation(annotations, IGNORE_CACHING, new TypeReference<Boolean>(){}, false)).application(KubernetesManifestAnnotater.getAnnotation(annotations, APPLICATION, new TypeReference<String>(){}, "")).build();
    }

    public static KubernetesManifestStrategy getStrategy(KubernetesManifest manifest) {
        return KubernetesManifestStrategy.fromAnnotations(manifest.getAnnotations());
    }

    public static void setDeploymentStrategy(KubernetesManifest manifest, KubernetesManifestStrategy.DeployStrategy strategy) {
        strategy.setAnnotations(manifest.getAnnotations());
    }

    public static KubernetesManifest getLastAppliedConfiguration(KubernetesManifest manifest) {
        Map<String, String> annotations = manifest.getAnnotations();
        return KubernetesManifestAnnotater.getAnnotation(annotations, KUBECTL_LAST_APPLIED_CONFIGURATION, new TypeReference<KubernetesManifest>(){}, null);
    }

    public static String getManifestCluster(KubernetesManifest manifest) {
        return Strings.nullToEmpty((String)manifest.getAnnotations().get(CLUSTER));
    }

    public static String getManifestApplication(KubernetesManifest manifest) {
        return Strings.nullToEmpty((String)manifest.getAnnotations().get(APPLICATION));
    }
}

