/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description.manifest;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;

@NonnullByDefault
public final class KubernetesManifestStrategy {
    private static final String STRATEGY_ANNOTATION_PREFIX = "strategy.spinnaker.io";
    private static final String VERSIONED = "strategy.spinnaker.io/versioned";
    static final String MAX_VERSION_HISTORY = "strategy.spinnaker.io/max-version-history";
    private static final String USE_SOURCE_CAPACITY = "strategy.spinnaker.io/use-source-capacity";
    private final DeployStrategy deployStrategy;
    private final Versioned versioned;
    private final OptionalInt maxVersionHistory;
    private final boolean useSourceCapacity;

    @ParametersAreNullableByDefault
    private KubernetesManifestStrategy(DeployStrategy deployStrategy, Versioned versioned, Integer maxVersionHistory, boolean useSourceCapacity) {
        this.deployStrategy = Optional.ofNullable(deployStrategy).orElse(DeployStrategy.APPLY);
        this.versioned = Optional.ofNullable(versioned).orElse(Versioned.DEFAULT);
        this.maxVersionHistory = maxVersionHistory == null ? OptionalInt.empty() : OptionalInt.of(maxVersionHistory);
        this.useSourceCapacity = useSourceCapacity;
    }

    static KubernetesManifestStrategy fromAnnotations(Map<String, String> annotations) {
        return KubernetesManifestStrategy.builder().versioned(Versioned.fromAnnotations(annotations)).deployStrategy(DeployStrategy.fromAnnotations(annotations)).useSourceCapacity(Boolean.parseBoolean(annotations.get(USE_SOURCE_CAPACITY))).maxVersionHistory(Ints.tryParse((String)annotations.getOrDefault(MAX_VERSION_HISTORY, ""))).build();
    }

    ImmutableMap<String, String> toAnnotations() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.deployStrategy.toAnnotations());
        builder.putAll(this.versioned.toAnnotations());
        if (this.maxVersionHistory.isPresent()) {
            builder.put((Object)MAX_VERSION_HISTORY, (Object)Integer.toString(this.maxVersionHistory.getAsInt()));
        }
        if (this.useSourceCapacity) {
            builder.put((Object)USE_SOURCE_CAPACITY, (Object)Boolean.TRUE.toString());
        }
        return builder.build();
    }

    @Generated
    public static KubernetesManifestStrategyBuilder builder() {
        return new KubernetesManifestStrategyBuilder();
    }

    @Generated
    public DeployStrategy getDeployStrategy() {
        return this.deployStrategy;
    }

    @Generated
    public Versioned getVersioned() {
        return this.versioned;
    }

    @Generated
    public OptionalInt getMaxVersionHistory() {
        return this.maxVersionHistory;
    }

    @Generated
    public boolean isUseSourceCapacity() {
        return this.useSourceCapacity;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesManifestStrategy)) {
            return false;
        }
        KubernetesManifestStrategy other = (KubernetesManifestStrategy)o;
        DeployStrategy this$deployStrategy = this.getDeployStrategy();
        DeployStrategy other$deployStrategy = other.getDeployStrategy();
        if (this$deployStrategy == null ? other$deployStrategy != null : !((Object)((Object)this$deployStrategy)).equals((Object)other$deployStrategy)) {
            return false;
        }
        Versioned this$versioned = this.getVersioned();
        Versioned other$versioned = other.getVersioned();
        if (this$versioned == null ? other$versioned != null : !((Object)((Object)this$versioned)).equals((Object)other$versioned)) {
            return false;
        }
        OptionalInt this$maxVersionHistory = this.getMaxVersionHistory();
        OptionalInt other$maxVersionHistory = other.getMaxVersionHistory();
        if (this$maxVersionHistory == null ? other$maxVersionHistory != null : !((Object)this$maxVersionHistory).equals(other$maxVersionHistory)) {
            return false;
        }
        return this.isUseSourceCapacity() == other.isUseSourceCapacity();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeployStrategy $deployStrategy = this.getDeployStrategy();
        result = result * 59 + ($deployStrategy == null ? 43 : ((Object)((Object)$deployStrategy)).hashCode());
        Versioned $versioned = this.getVersioned();
        result = result * 59 + ($versioned == null ? 43 : ((Object)((Object)$versioned)).hashCode());
        OptionalInt $maxVersionHistory = this.getMaxVersionHistory();
        result = result * 59 + ($maxVersionHistory == null ? 43 : ((Object)$maxVersionHistory).hashCode());
        result = result * 59 + (this.isUseSourceCapacity() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesManifestStrategy(deployStrategy=" + this.getDeployStrategy() + ", versioned=" + this.getVersioned() + ", maxVersionHistory=" + this.getMaxVersionHistory() + ", useSourceCapacity=" + this.isUseSourceCapacity() + ")";
    }

    @Generated
    public static class KubernetesManifestStrategyBuilder {
        @Generated
        private DeployStrategy deployStrategy;
        @Generated
        private Versioned versioned;
        @Generated
        private Integer maxVersionHistory;
        @Generated
        private boolean useSourceCapacity;

        @Generated
        KubernetesManifestStrategyBuilder() {
        }

        @Generated
        public KubernetesManifestStrategyBuilder deployStrategy(DeployStrategy deployStrategy) {
            this.deployStrategy = deployStrategy;
            return this;
        }

        @Generated
        public KubernetesManifestStrategyBuilder versioned(Versioned versioned) {
            this.versioned = versioned;
            return this;
        }

        @Generated
        public KubernetesManifestStrategyBuilder maxVersionHistory(Integer maxVersionHistory) {
            this.maxVersionHistory = maxVersionHistory;
            return this;
        }

        @Generated
        public KubernetesManifestStrategyBuilder useSourceCapacity(boolean useSourceCapacity) {
            this.useSourceCapacity = useSourceCapacity;
            return this;
        }

        @Generated
        public KubernetesManifestStrategy build() {
            return new KubernetesManifestStrategy(this.deployStrategy, this.versioned, this.maxVersionHistory, this.useSourceCapacity);
        }

        @Generated
        public String toString() {
            return "KubernetesManifestStrategy.KubernetesManifestStrategyBuilder(deployStrategy=" + this.deployStrategy + ", versioned=" + this.versioned + ", maxVersionHistory=" + this.maxVersionHistory + ", useSourceCapacity=" + this.useSourceCapacity + ")";
        }
    }

    public static enum DeployStrategy {
        APPLY(null),
        RECREATE("strategy.spinnaker.io/recreate"),
        REPLACE("strategy.spinnaker.io/replace");

        @Nullable
        private final String annotation;

        private DeployStrategy(String annotation) {
            this.annotation = annotation;
        }

        static DeployStrategy fromAnnotations(Map<String, String> annotations) {
            if (Boolean.parseBoolean(annotations.get(DeployStrategy.RECREATE.annotation))) {
                return RECREATE;
            }
            if (Boolean.parseBoolean(annotations.get(DeployStrategy.REPLACE.annotation))) {
                return REPLACE;
            }
            return APPLY;
        }

        ImmutableMap<String, String> toAnnotations() {
            if (this.annotation == null) {
                return ImmutableMap.of();
            }
            return ImmutableMap.of((Object)this.annotation, (Object)Boolean.TRUE.toString());
        }

        void setAnnotations(Map<String, String> annotations) {
            Arrays.stream(DeployStrategy.values()).map(s -> s.annotation).filter(Objects::nonNull).forEach(annotations::remove);
            annotations.putAll((Map<String, String>)this.toAnnotations());
        }
    }

    public static enum Versioned {
        TRUE((ImmutableMap<String, String>)ImmutableMap.of((Object)"strategy.spinnaker.io/versioned", (Object)Boolean.TRUE.toString())),
        FALSE((ImmutableMap<String, String>)ImmutableMap.of((Object)"strategy.spinnaker.io/versioned", (Object)Boolean.FALSE.toString())),
        DEFAULT((ImmutableMap<String, String>)ImmutableMap.of());

        private final ImmutableMap<String, String> annotations;

        private Versioned(ImmutableMap<String, String> annotations) {
            this.annotations = annotations;
        }

        static Versioned fromAnnotations(Map<String, String> annotations) {
            if (annotations.containsKey(KubernetesManifestStrategy.VERSIONED)) {
                return Boolean.parseBoolean(annotations.get(KubernetesManifestStrategy.VERSIONED)) ? TRUE : FALSE;
            }
            return DEFAULT;
        }

        ImmutableMap<String, String> toAnnotations() {
            return this.annotations;
        }
    }
}

