/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.health;

import com.google.common.collect.ImmutableList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.core.AccountHealthIndicator;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class KubernetesHealthIndicator
extends AccountHealthIndicator<KubernetesNamedAccountCredentials> {
    private static final String ID = "kubernetes";
    private final CredentialsRepository<KubernetesNamedAccountCredentials> credentialsRepository;

    @Autowired
    public KubernetesHealthIndicator(Registry registry, CredentialsRepository<KubernetesNamedAccountCredentials> credentialsRepository) {
        super(ID, registry);
        this.credentialsRepository = credentialsRepository;
    }

    protected ImmutableList<KubernetesNamedAccountCredentials> getAccounts() {
        return ImmutableList.copyOf((Collection)this.credentialsRepository.getAll());
    }

    protected Optional<String> accountHealth(KubernetesNamedAccountCredentials accountCredentials) {
        try {
            accountCredentials.getCredentials().getDeclaredNamespaces();
            return Optional.empty();
        }
        catch (RuntimeException e) {
            return Optional.of(e.getMessage());
        }
    }
}

