/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesSelectorList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface CanDelete {
    public KubernetesKind kind();

    default public OperationResult delete(KubernetesCredentials credentials, String namespace, String name, KubernetesSelectorList labelSelectors, V1DeleteOptions options) {
        options = options == null ? new V1DeleteOptions() : options;
        List<String> deletedNames = credentials.delete(this.kind(), namespace, name, labelSelectors, options);
        OperationResult result = new OperationResult();
        Set fullNames = deletedNames.stream().map(n -> KubernetesManifest.getFullResourceName(this.kind(), n)).collect(Collectors.toSet());
        result.setManifestNamesByNamespace(new HashMap<String, Set<String>>((Map<String, Set<String>>)ImmutableMap.of((Object)namespace, fullNames)));
        return result;
    }
}

