/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesManifestProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanDeploy;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;

public abstract class KubernetesHandler
implements CanDeploy,
CanDelete,
CanPatch {
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    private final ArtifactReplacer artifactReplacer = new ArtifactReplacer((Collection<Replacer>)this.artifactReplacers());
    @Value(value="${kubernetes.artifact-binding.docker-image:match-name-and-tag}")
    protected String dockerImageBinding;

    protected KubernetesHandler() {
    }

    public abstract int deployPriority();

    @Override
    @Nonnull
    public abstract KubernetesKind kind();

    public abstract boolean versioned();

    @Nonnull
    public abstract SpinnakerKind spinnakerKind();

    public abstract Manifest.Status status(KubernetesManifest var1);

    public List<Manifest.Warning> listWarnings(KubernetesManifest manifest) {
        return new ArrayList<Manifest.Warning>();
    }

    protected List<String> sensitiveKeys() {
        return new ArrayList<String>();
    }

    @Nonnull
    protected ImmutableList<Replacer> artifactReplacers() {
        return ImmutableList.of();
    }

    public ArtifactReplacer.ReplaceResult replaceArtifacts(KubernetesManifest manifest, List<Artifact> artifacts, @Nonnull String account) {
        return this.artifactReplacer.replaceAll(this.dockerImageBinding, manifest, artifacts, manifest.getNamespace(), account);
    }

    public ArtifactReplacer.ReplaceResult replaceArtifacts(KubernetesManifest manifest, List<Artifact> artifacts, @Nonnull String namespace, @Nonnull String account) {
        return this.artifactReplacer.replaceAll(this.dockerImageBinding, manifest, artifacts, namespace, account);
    }

    protected abstract KubernetesCachingAgentFactory cachingAgentFactory();

    public ImmutableSet<Artifact> listArtifacts(KubernetesManifest manifest) {
        return this.artifactReplacer.findAll(manifest);
    }

    public KubernetesCachingAgent buildCachingAgent(KubernetesNamedAccountCredentials namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval) {
        return this.cachingAgentFactory().buildCachingAgent(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount, agentInterval);
    }

    public void removeSensitiveKeys(KubernetesManifest manifest) {
        List<String> sensitiveKeys = this.sensitiveKeys();
        sensitiveKeys.forEach(manifest::remove);
    }

    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key) {
        Map result = (Map)objectMapper.convertValue((Object)key, (TypeReference)new TypeReference<Map<String, Object>>(){});
        result.put("region", key.getNamespace());
        result.put("name", KubernetesManifest.getFullResourceName(key.getKubernetesKind(), key.getName()));
        return result;
    }

    public void addRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources, Map<KubernetesManifest, List<KubernetesManifest>> relationshipMap) {
    }

    public Comparator<KubernetesManifest> comparatorFor(KubernetesManifestProvider.Sort sort) {
        switch (sort) {
            case AGE: {
                return this.ageComparator();
            }
            case SIZE: {
                return this.sizeComparator();
            }
        }
        throw new IllegalArgumentException("No comparator for " + sort + " found");
    }

    protected Comparator<KubernetesManifest> ageComparator() {
        return Comparator.comparing(KubernetesManifest::getCreationTimestamp);
    }

    protected Comparator<KubernetesManifest> sizeComparator() {
        return Comparator.comparing(m -> m.getReplicas() == null ? -1 : m.getReplicas());
    }

    public static enum DeployPriority {
        LOWEST_PRIORITY(1000),
        WORKLOAD_ATTACHMENT_PRIORITY(110),
        WORKLOAD_CONTROLLER_PRIORITY(100),
        WORKLOAD_PRIORITY(100),
        WORKLOAD_MODIFIER_PRIORITY(90),
        PDB_PRIORITY(90),
        API_SERVICE_PRIORITY(80),
        NETWORK_RESOURCE_PRIORITY(70),
        MOUNTABLE_DATA_PRIORITY(50),
        MOUNTABLE_DATA_BACKING_RESOURCE_PRIORITY(40),
        SERVICE_ACCOUNT_PRIORITY(40),
        STORAGE_CLASS_PRIORITY(40),
        ADMISSION_PRIORITY(40),
        RESOURCE_DEFINITION_PRIORITY(30),
        ROLE_BINDING_PRIORITY(30),
        ROLE_PRIORITY(20),
        NAMESPACE_PRIORITY(0);

        private final int value;

        private DeployPriority(int value) {
            this.value = value;
        }

        public static DeployPriority fromString(String val) {
            if (val == null) {
                return null;
            }
            return Arrays.stream(DeployPriority.values()).filter(v -> v.toString().equalsIgnoreCase(val)).findFirst().orElseThrow(() -> new IllegalArgumentException("No such priority '" + val + "'"));
        }

        @Generated
        public int getValue() {
            return this.value;
        }
    }
}

