/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesPauseRolloutManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanPauseRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesPauseRolloutManifestOperation
implements AtomicOperation<Void> {
    private final KubernetesPauseRolloutManifestDescription description;
    private final KubernetesCredentials credentials;
    private static final String OP_NAME = "PAUSE_ROLLOUT_KUBERNETES_MANIFEST";

    public KubernetesPauseRolloutManifestOperation(KubernetesPauseRolloutManifestDescription description) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List<Void> priorOutputs) {
        KubernetesPauseRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Starting pause rollout operation...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesPauseRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesHandler deployer = this.credentials.getResourcePropertyRegistry().get(coordinates.getKind()).getHandler();
        if (!(deployer instanceof CanPauseRollout)) {
            throw new IllegalArgumentException("Resource with " + coordinates + " does not support pause rollout");
        }
        CanPauseRollout canPauseRollout = (CanPauseRollout)((Object)deployer);
        KubernetesPauseRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Calling pause rollout operation...");
        canPauseRollout.pauseRollout(this.credentials, coordinates.getNamespace(), coordinates.getName());
        return null;
    }
}

