/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesResumeRolloutManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanResumeRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesResumeRolloutManifestOperation
implements AtomicOperation<Void> {
    private final KubernetesResumeRolloutManifestDescription description;
    private final KubernetesCredentials credentials;
    private static final String OP_NAME = "RESUME_ROLLOUT_KUBERNETES_MANIFEST";

    public KubernetesResumeRolloutManifestOperation(KubernetesResumeRolloutManifestDescription description) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List<Void> priorOutputs) {
        KubernetesResumeRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Starting resume rollout operation...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesResumeRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesHandler deployer = this.credentials.getResourcePropertyRegistry().get(coordinates.getKind()).getHandler();
        if (!(deployer instanceof CanResumeRollout)) {
            throw new IllegalArgumentException("Resource with " + coordinates + " does not support resume rollout");
        }
        CanResumeRollout canResumeRollout = (CanResumeRollout)((Object)deployer);
        KubernetesResumeRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Calling resume rollout operation...");
        canResumeRollout.resumeRollout(this.credentials, coordinates.getNamespace(), coordinates.getName());
        return null;
    }
}

