/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKindProperties;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@NonnullByDefault
public final class GlobalKubernetesKindRegistry {
    private final ImmutableMap<KubernetesKind, KubernetesKindProperties> nameMap;

    @Autowired
    public GlobalKubernetesKindRegistry() {
        this(KubernetesKindProperties.getGlobalKindProperties());
    }

    public GlobalKubernetesKindRegistry(Iterable<KubernetesKindProperties> kubernetesKindProperties) {
        this.nameMap = (ImmutableMap)StreamSupport.stream(kubernetesKindProperties.spliterator(), false).collect(ImmutableMap.toImmutableMap(KubernetesKindProperties::getKubernetesKind, p -> p));
    }

    Optional<KubernetesKindProperties> getKindProperties(KubernetesKind kind) {
        return Optional.ofNullable((KubernetesKindProperties)this.nameMap.get((Object)kind));
    }

    ImmutableSet<KubernetesKind> getRegisteredKinds() {
        return this.nameMap.keySet();
    }
}

