/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.KubernetesProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesAccountProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesConfigurationProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.health.KubernetesHealthIndicator;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.security.CredentialsInitializerSynchronizable;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.MapBackedCredentialsRepository;
import com.netflix.spinnaker.credentials.definition.AbstractCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.BasicCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinitionSource;
import com.netflix.spinnaker.credentials.poller.Poller;
import javax.annotation.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableConfigurationProperties
@EnableScheduling
@ConditionalOnProperty(value={"kubernetes.enabled"})
@ComponentScan(value={"com.netflix.spinnaker.clouddriver.kubernetes"})
public class KubernetesConfiguration {
    @Bean
    @RefreshScope
    @ConfigurationProperties(value="kubernetes")
    public KubernetesConfigurationProperties kubernetesConfigurationProperties() {
        return new KubernetesConfigurationProperties();
    }

    @Bean
    @RefreshScope
    @ConfigurationProperties(value="kubernetes")
    public KubernetesAccountProperties kubernetesAccountProperties() {
        return new KubernetesAccountProperties();
    }

    @Bean
    public KubernetesHealthIndicator kubernetesHealthIndicator(Registry registry, CredentialsRepository<KubernetesNamedAccountCredentials> credentialsRepository) {
        return new KubernetesHealthIndicator(registry, credentialsRepository);
    }

    @Bean
    public KubernetesProvider kubernetesProvider() {
        return new KubernetesProvider();
    }

    @Bean
    @ConditionalOnMissingBean(value={KubernetesNamedAccountCredentials.class}, parameterizedContainer={AbstractCredentialsLoader.class})
    public AbstractCredentialsLoader<KubernetesNamedAccountCredentials> kubernetesCredentialsLoader(@Nullable CredentialsDefinitionSource<KubernetesAccountProperties.ManagedAccount> kubernetesCredentialSource, KubernetesAccountProperties accountProperties, KubernetesCredentials.Factory credentialFactory, CredentialsRepository<KubernetesNamedAccountCredentials> kubernetesCredentialsRepository) {
        if (kubernetesCredentialSource == null) {
            kubernetesCredentialSource = accountProperties::getAccounts;
        }
        return new BasicCredentialsLoader(kubernetesCredentialSource, a -> new KubernetesNamedAccountCredentials((KubernetesAccountProperties.ManagedAccount)a, credentialFactory), kubernetesCredentialsRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={KubernetesNamedAccountCredentials.class}, parameterizedContainer={CredentialsRepository.class})
    public CredentialsRepository<KubernetesNamedAccountCredentials> kubernetesCredentialsRepository(CredentialsLifecycleHandler<KubernetesNamedAccountCredentials> eventHandler) {
        return new MapBackedCredentialsRepository("kubernetes", eventHandler);
    }

    @Bean
    @ConditionalOnMissingBean(value={KubernetesAccountProperties.ManagedAccount.class}, parameterizedContainer={CredentialsDefinitionSource.class})
    public CredentialsInitializerSynchronizable kubernetesCredentialsInitializerSynchronizable(AbstractCredentialsLoader<KubernetesNamedAccountCredentials> loader) {
        final Poller poller = new Poller(loader);
        return new CredentialsInitializerSynchronizable(){

            public void synchronize() {
                poller.run();
            }
        };
    }
}

