/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesHealth;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesResource;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.provider.KubernetesModelUtil;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Instance;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerInstance;
import com.netflix.spinnaker.moniker.Moniker;
import io.kubernetes.client.openapi.models.V1PodStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.Null;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubernetesInstance
implements Instance,
KubernetesResource {
    private static final Logger log = LoggerFactory.getLogger(KubernetesInstance.class);
    private final List<Map<String, Object>> health;
    private final String account;
    private final String name;
    private final String humanReadableName;
    private final String namespace;
    private final String displayName;
    private final KubernetesApiVersion apiVersion;
    private final KubernetesKind kind;
    private final Map<String, String> labels;
    private final Moniker moniker;
    private final Long createdTime;

    @Null
    public Long getLaunchTime() {
        return null;
    }

    private KubernetesInstance(KubernetesManifest manifest, String key, Moniker moniker) {
        this.account = ((Keys.InfrastructureCacheKey)Keys.parseKey(key).get()).getAccount();
        this.name = manifest.getUid();
        this.humanReadableName = manifest.getFullResourceName();
        this.namespace = manifest.getNamespace();
        this.displayName = manifest.getName();
        this.apiVersion = manifest.getApiVersion();
        this.kind = manifest.getKind();
        this.labels = ImmutableMap.copyOf(manifest.getLabels());
        this.moniker = moniker;
        this.createdTime = manifest.getCreationTimestampEpochMillis();
        this.health = new ArrayList<Map<String, Object>>();
        V1PodStatus status = KubernetesCacheDataConverter.getResource(manifest.getStatus(), V1PodStatus.class);
        if (status != null) {
            this.health.add(new KubernetesHealth(status).toMap());
            if (status.getContainerStatuses() != null) {
                this.health.addAll(status.getContainerStatuses().stream().map(KubernetesHealth::new).map(KubernetesHealth::toMap).collect(Collectors.toList()));
            }
        }
    }

    public static KubernetesInstance fromCacheData(CacheData cd) {
        if (cd == null) {
            return null;
        }
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(cd);
        if (manifest == null) {
            log.warn("Cache data {} inserted without a manifest", (Object)cd.getId());
            return null;
        }
        Moniker moniker = KubernetesCacheDataConverter.getMoniker(cd);
        return new KubernetesInstance(manifest, cd.getId(), moniker);
    }

    public LoadBalancerInstance toLoadBalancerInstance() {
        return LoadBalancerInstance.builder().health((Map)this.health.stream().reduce(new HashMap(), (a, b) -> {
            HashMap result = new HashMap();
            result.putAll(a);
            result.putAll(b);
            return result;
        })).id(this.getName()).zone(this.getZone()).name(this.getHumanReadableName()).build();
    }

    public HealthState getHealthState() {
        return KubernetesModelUtil.getHealthState(this.health);
    }

    public String getZone() {
        return this.namespace;
    }

    public String getCloudProvider() {
        return "kubernetes";
    }

    @Generated
    public List<Map<String, Object>> getHealth() {
        return this.health;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    @Override
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public KubernetesApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @Generated
    public KubernetesKind getKind() {
        return this.kind;
    }

    @Generated
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Generated
    public Moniker getMoniker() {
        return this.moniker;
    }

    @Override
    @Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesInstance)) {
            return false;
        }
        KubernetesInstance other = (KubernetesInstance)o;
        Long this$createdTime = this.getCreatedTime();
        Long other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        List<Map<String, Object>> this$health = this.getHealth();
        List<Map<String, Object>> other$health = other.getHealth();
        if (this$health == null ? other$health != null : !((Object)this$health).equals(other$health)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$humanReadableName = this.getHumanReadableName();
        String other$humanReadableName = other.getHumanReadableName();
        if (this$humanReadableName == null ? other$humanReadableName != null : !this$humanReadableName.equals(other$humanReadableName)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        KubernetesApiVersion this$apiVersion = this.getApiVersion();
        KubernetesApiVersion other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !((Object)this$apiVersion).equals(other$apiVersion)) {
            return false;
        }
        KubernetesKind this$kind = this.getKind();
        KubernetesKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)this$kind).equals(other$kind)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Moniker this$moniker = this.getMoniker();
        Moniker other$moniker = other.getMoniker();
        return !(this$moniker == null ? other$moniker != null : !this$moniker.equals(other$moniker));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        List<Map<String, Object>> $health = this.getHealth();
        result = result * 59 + ($health == null ? 43 : ((Object)$health).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $humanReadableName = this.getHumanReadableName();
        result = result * 59 + ($humanReadableName == null ? 43 : $humanReadableName.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        KubernetesApiVersion $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : ((Object)$apiVersion).hashCode());
        KubernetesKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)$kind).hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Moniker $moniker = this.getMoniker();
        result = result * 59 + ($moniker == null ? 43 : $moniker.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesInstance(health=" + this.getHealth() + ", account=" + this.getAccount() + ", name=" + this.getName() + ", humanReadableName=" + this.getHumanReadableName() + ", namespace=" + this.getNamespace() + ", displayName=" + this.getDisplayName() + ", apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", labels=" + this.getLabels() + ", moniker=" + this.getMoniker() + ", createdTime=" + this.getCreatedTime() + ")";
    }
}

