/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesResource;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubernetesRawResource
implements KubernetesResource {
    private static final Logger log = LoggerFactory.getLogger(KubernetesRawResource.class);
    private final String account;
    private final String name;
    private final String namespace;
    private final String displayName;
    private final KubernetesApiVersion apiVersion;
    private final KubernetesKind kind;
    private final Map<String, String> labels;
    private final Moniker moniker;
    private final Long createdTime;

    private KubernetesRawResource(KubernetesManifest manifest, String key, Moniker moniker) {
        this.account = ((Keys.InfrastructureCacheKey)Keys.parseKey(key).get()).getAccount();
        this.name = manifest.getFullResourceName();
        this.displayName = manifest.getName();
        this.apiVersion = manifest.getApiVersion();
        this.kind = manifest.getKind();
        this.namespace = manifest.getNamespace();
        this.labels = ImmutableMap.copyOf(manifest.getLabels());
        this.moniker = moniker;
        this.createdTime = manifest.getCreationTimestampEpochMillis();
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public static KubernetesRawResource fromCacheData(CacheData cd) {
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(cd);
        if (manifest == null) {
            log.warn("Cache data {} inserted without a manifest", (Object)cd.getId());
            return null;
        }
        Moniker moniker = KubernetesCacheDataConverter.getMoniker(cd);
        return new KubernetesRawResource(manifest, cd.getId(), moniker);
    }

    public String getRegion() {
        return this.namespace;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public KubernetesApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @Generated
    public KubernetesKind getKind() {
        return this.kind;
    }

    @Generated
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Generated
    public Moniker getMoniker() {
        return this.moniker;
    }

    @Override
    @Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesRawResource)) {
            return false;
        }
        KubernetesRawResource other = (KubernetesRawResource)o;
        Long this$createdTime = this.getCreatedTime();
        Long other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        KubernetesApiVersion this$apiVersion = this.getApiVersion();
        KubernetesApiVersion other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !((Object)this$apiVersion).equals(other$apiVersion)) {
            return false;
        }
        KubernetesKind this$kind = this.getKind();
        KubernetesKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)this$kind).equals(other$kind)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Moniker this$moniker = this.getMoniker();
        Moniker other$moniker = other.getMoniker();
        return !(this$moniker == null ? other$moniker != null : !this$moniker.equals(other$moniker));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        KubernetesApiVersion $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : ((Object)$apiVersion).hashCode());
        KubernetesKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)$kind).hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Moniker $moniker = this.getMoniker();
        result = result * 59 + ($moniker == null ? 43 : $moniker.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesRawResource(account=" + this.getAccount() + ", name=" + this.getName() + ", namespace=" + this.getNamespace() + ", displayName=" + this.getDisplayName() + ", apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", labels=" + this.getLabels() + ", moniker=" + this.getMoniker() + ", createdTime=" + this.getCreatedTime() + ")";
    }
}

