/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesImageSummary;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesInstance;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesResource;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesServerGroupSummary;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.data.KubernetesServerGroupCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestTraffic;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerServerGroup;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.clouddriver.model.ServerGroupManager;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.Null;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubernetesServerGroup
implements KubernetesResource,
ServerGroup {
    private static final Logger log = LoggerFactory.getLogger(KubernetesServerGroup.class);
    private final boolean disabled;
    private final Set<KubernetesInstance> instances;
    private final Set<String> loadBalancers;
    private final List<ServerGroupManager.ServerGroupManagerSummary> serverGroupManagers;
    private final ServerGroup.Capacity capacity;
    private final String account;
    private final String name;
    private final String namespace;
    private final String displayName;
    private final KubernetesApiVersion apiVersion;
    private final KubernetesKind kind;
    private final Map<String, String> labels;
    private final Moniker moniker;
    private final Long createdTime;
    private final ImmutableMap<String, ImmutableList<String>> buildInfo;
    private final Set<String> zones = ImmutableSet.of();
    private final Set<String> securityGroups = ImmutableSet.of();
    private final Map<String, Object> launchConfig = ImmutableMap.of();
    @JsonIgnore
    private static final ArtifactReplacer dockerImageReplacer = new ArtifactReplacer((Collection<Replacer>)ImmutableList.of((Object)Replacer.dockerImage()));

    public ServerGroup.InstanceCounts getInstanceCounts() {
        return ServerGroup.InstanceCounts.builder().total(Integer.valueOf(Ints.checkedCast((long)this.instances.size()))).up(Integer.valueOf(Ints.checkedCast((long)this.instances.stream().filter(i -> i.getHealthState().equals((Object)HealthState.Up)).count()))).down(Integer.valueOf(Ints.checkedCast((long)this.instances.stream().filter(i -> i.getHealthState().equals((Object)HealthState.Down)).count()))).unknown(Integer.valueOf(Ints.checkedCast((long)this.instances.stream().filter(i -> i.getHealthState().equals((Object)HealthState.Unknown)).count()))).outOfService(Integer.valueOf(Ints.checkedCast((long)this.instances.stream().filter(i -> i.getHealthState().equals((Object)HealthState.OutOfService)).count()))).starting(Integer.valueOf(Ints.checkedCast((long)this.instances.stream().filter(i -> i.getHealthState().equals((Object)HealthState.Starting)).count()))).build();
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    private KubernetesServerGroup(KubernetesManifest manifest, String key, Moniker moniker, List<KubernetesInstance> instances, Set<String> loadBalancers, List<ServerGroupManager.ServerGroupManagerSummary> serverGroupManagers, Boolean disabled) {
        this.account = ((Keys.InfrastructureCacheKey)Keys.parseKey(key).get()).getAccount();
        this.kind = manifest.getKind();
        this.apiVersion = manifest.getApiVersion();
        this.namespace = manifest.getNamespace();
        this.name = manifest.getFullResourceName();
        this.displayName = manifest.getName();
        this.labels = ImmutableMap.copyOf(manifest.getLabels());
        this.moniker = moniker;
        this.createdTime = manifest.getCreationTimestampEpochMillis();
        this.buildInfo = ImmutableMap.of((Object)"images", (Object)((ImmutableList)dockerImageReplacer.findAll(manifest).stream().map(Artifact::getReference).distinct().collect(ImmutableList.toImmutableList())));
        this.instances = new HashSet<KubernetesInstance>(instances);
        this.loadBalancers = loadBalancers;
        this.serverGroupManagers = serverGroupManagers;
        this.disabled = disabled;
        Integer odesired = ((Map)manifest.getOrDefault("spec", new HashMap())).getOrDefault("replicas", 0);
        int desired = 0;
        if (odesired instanceof Number) {
            desired = ((Number)odesired).intValue();
        } else {
            log.warn("Unable to cast replica count from unexpected type: {}", odesired.getClass());
        }
        this.capacity = ServerGroup.Capacity.builder().desired(Integer.valueOf(desired)).build();
    }

    public static KubernetesServerGroup fromCacheData(KubernetesServerGroupCacheData cacheData) {
        List<ServerGroupManager.ServerGroupManagerSummary> serverGroupManagers = cacheData.getServerGroupManagerKeys().stream().map(Keys::parseKey).filter(Optional::isPresent).map(Optional::get).filter(k -> k instanceof Keys.InfrastructureCacheKey).map(k -> (Keys.InfrastructureCacheKey)k).map(k -> ServerGroupManager.ServerGroupManagerSummary.builder().account(k.getAccount()).location(k.getNamespace()).name(k.getName()).build()).collect(Collectors.toList());
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(cacheData.getServerGroupData());
        if (manifest == null) {
            log.warn("Cache data {} inserted without a manifest", (Object)cacheData.getServerGroupData().getId());
            return null;
        }
        List<KubernetesInstance> instances = cacheData.getInstanceData().stream().map(KubernetesInstance::fromCacheData).filter(Objects::nonNull).collect(Collectors.toList());
        KubernetesManifestTraffic traffic = KubernetesManifestAnnotater.getTraffic(manifest);
        Set explicitLoadBalancers = traffic.getLoadBalancers().stream().map(lb -> KubernetesCoordinates.builder().fullResourceName((String)lb).build()).map(c -> KubernetesManifest.getFullResourceName(c.getKind(), c.getName())).collect(Collectors.toSet());
        Set<String> loadBalancers = cacheData.getLoadBalancerKeys().stream().map(Keys::parseKey).filter(Optional::isPresent).map(Optional::get).map(k -> (Keys.InfrastructureCacheKey)k).map(k -> KubernetesManifest.getFullResourceName(k.getKubernetesKind(), k.getName())).collect(Collectors.toSet());
        boolean disabled = loadBalancers.isEmpty() && !explicitLoadBalancers.isEmpty();
        loadBalancers.addAll(explicitLoadBalancers);
        Moniker moniker = KubernetesCacheDataConverter.getMoniker(cacheData.getServerGroupData());
        return new KubernetesServerGroup(manifest, cacheData.getServerGroupData().getId(), moniker, instances, loadBalancers, serverGroupManagers, disabled);
    }

    public KubernetesServerGroupSummary toServerGroupSummary() {
        return KubernetesServerGroupSummary.builder().name(this.getName()).account(this.getAccount()).namespace(this.getRegion()).moniker(this.getMoniker()).build();
    }

    public LoadBalancerServerGroup toLoadBalancerServerGroup() {
        return LoadBalancerServerGroup.builder().account(this.getAccount()).detachedInstances(new HashSet()).instances(this.instances.stream().map(KubernetesInstance::toLoadBalancerInstance).collect(Collectors.toSet())).name(this.getName()).region(this.getRegion()).isDisabled(this.isDisabled()).cloudProvider("kubernetes").build();
    }

    @Deprecated
    @Null
    public ServerGroup.ImageSummary getImageSummary() {
        return null;
    }

    public ServerGroup.ImagesSummary getImagesSummary() {
        return () -> ImmutableList.of((Object)KubernetesImageSummary.builder().serverGroupName(this.displayName).buildInfo((Map<String, ? extends ImmutableCollection<String>>)this.buildInfo).build());
    }

    public String getRegion() {
        return this.namespace;
    }

    public String getCloudProvider() {
        return "kubernetes";
    }

    @Generated
    public Set<KubernetesInstance> getInstances() {
        return this.instances;
    }

    @Generated
    public Set<String> getLoadBalancers() {
        return this.loadBalancers;
    }

    @Generated
    public List<ServerGroupManager.ServerGroupManagerSummary> getServerGroupManagers() {
        return this.serverGroupManagers;
    }

    @Generated
    public ServerGroup.Capacity getCapacity() {
        return this.capacity;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public KubernetesApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @Generated
    public KubernetesKind getKind() {
        return this.kind;
    }

    @Generated
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Generated
    public Moniker getMoniker() {
        return this.moniker;
    }

    @Override
    @Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public ImmutableMap<String, ImmutableList<String>> getBuildInfo() {
        return this.buildInfo;
    }

    @Generated
    public Set<String> getZones() {
        return this.zones;
    }

    @Generated
    public Set<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Generated
    public Map<String, Object> getLaunchConfig() {
        return this.launchConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesServerGroup)) {
            return false;
        }
        KubernetesServerGroup other = (KubernetesServerGroup)o;
        Boolean this$disabled = this.isDisabled();
        Boolean other$disabled = other.isDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        Long this$createdTime = this.getCreatedTime();
        Long other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Set<KubernetesInstance> this$instances = this.getInstances();
        Set<KubernetesInstance> other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances)) {
            return false;
        }
        Set<String> this$loadBalancers = this.getLoadBalancers();
        Set<String> other$loadBalancers = other.getLoadBalancers();
        if (this$loadBalancers == null ? other$loadBalancers != null : !((Object)this$loadBalancers).equals(other$loadBalancers)) {
            return false;
        }
        List<ServerGroupManager.ServerGroupManagerSummary> this$serverGroupManagers = this.getServerGroupManagers();
        List<ServerGroupManager.ServerGroupManagerSummary> other$serverGroupManagers = other.getServerGroupManagers();
        if (this$serverGroupManagers == null ? other$serverGroupManagers != null : !((Object)this$serverGroupManagers).equals(other$serverGroupManagers)) {
            return false;
        }
        ServerGroup.Capacity this$capacity = this.getCapacity();
        ServerGroup.Capacity other$capacity = other.getCapacity();
        if (this$capacity == null ? other$capacity != null : !this$capacity.equals(other$capacity)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        KubernetesApiVersion this$apiVersion = this.getApiVersion();
        KubernetesApiVersion other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !((Object)this$apiVersion).equals(other$apiVersion)) {
            return false;
        }
        KubernetesKind this$kind = this.getKind();
        KubernetesKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)this$kind).equals(other$kind)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Moniker this$moniker = this.getMoniker();
        Moniker other$moniker = other.getMoniker();
        if (this$moniker == null ? other$moniker != null : !this$moniker.equals(other$moniker)) {
            return false;
        }
        ImmutableMap<String, ImmutableList<String>> this$buildInfo = this.getBuildInfo();
        ImmutableMap<String, ImmutableList<String>> other$buildInfo = other.getBuildInfo();
        if (this$buildInfo == null ? other$buildInfo != null : !this$buildInfo.equals(other$buildInfo)) {
            return false;
        }
        Set<String> this$zones = this.getZones();
        Set<String> other$zones = other.getZones();
        if (this$zones == null ? other$zones != null : !((Object)this$zones).equals(other$zones)) {
            return false;
        }
        Set<String> this$securityGroups = this.getSecurityGroups();
        Set<String> other$securityGroups = other.getSecurityGroups();
        if (this$securityGroups == null ? other$securityGroups != null : !((Object)this$securityGroups).equals(other$securityGroups)) {
            return false;
        }
        Map<String, Object> this$launchConfig = this.getLaunchConfig();
        Map<String, Object> other$launchConfig = other.getLaunchConfig();
        return !(this$launchConfig == null ? other$launchConfig != null : !((Object)this$launchConfig).equals(other$launchConfig));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disabled = this.isDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        Long $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Set<KubernetesInstance> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        Set<String> $loadBalancers = this.getLoadBalancers();
        result = result * 59 + ($loadBalancers == null ? 43 : ((Object)$loadBalancers).hashCode());
        List<ServerGroupManager.ServerGroupManagerSummary> $serverGroupManagers = this.getServerGroupManagers();
        result = result * 59 + ($serverGroupManagers == null ? 43 : ((Object)$serverGroupManagers).hashCode());
        ServerGroup.Capacity $capacity = this.getCapacity();
        result = result * 59 + ($capacity == null ? 43 : $capacity.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        KubernetesApiVersion $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : ((Object)$apiVersion).hashCode());
        KubernetesKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)$kind).hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Moniker $moniker = this.getMoniker();
        result = result * 59 + ($moniker == null ? 43 : $moniker.hashCode());
        ImmutableMap<String, ImmutableList<String>> $buildInfo = this.getBuildInfo();
        result = result * 59 + ($buildInfo == null ? 43 : $buildInfo.hashCode());
        Set<String> $zones = this.getZones();
        result = result * 59 + ($zones == null ? 43 : ((Object)$zones).hashCode());
        Set<String> $securityGroups = this.getSecurityGroups();
        result = result * 59 + ($securityGroups == null ? 43 : ((Object)$securityGroups).hashCode());
        Map<String, Object> $launchConfig = this.getLaunchConfig();
        result = result * 59 + ($launchConfig == null ? 43 : ((Object)$launchConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesServerGroup(disabled=" + this.isDisabled() + ", instances=" + this.getInstances() + ", loadBalancers=" + this.getLoadBalancers() + ", serverGroupManagers=" + this.getServerGroupManagers() + ", capacity=" + this.getCapacity() + ", account=" + this.getAccount() + ", name=" + this.getName() + ", namespace=" + this.getNamespace() + ", displayName=" + this.getDisplayName() + ", apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", labels=" + this.getLabels() + ", moniker=" + this.getMoniker() + ", createdTime=" + this.getCreatedTime() + ", buildInfo=" + this.getBuildInfo() + ", zones=" + this.getZones() + ", securityGroups=" + this.getSecurityGroups() + ", launchConfig=" + this.getLaunchConfig() + ")";
    }
}

