/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.deploy.converters;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesAtomicOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsConverter;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class KubernetesAtomicOperationConverterHelper {
    public static <T extends KubernetesAtomicOperationDescription> T convertDescription(Map<String, Object> input, AbstractAtomicOperationsCredentialsConverter<KubernetesNamedAccountCredentials> credentialsSupport, Class<T> targetDescriptionType) {
        String account = (String)input.get("account");
        String removedAccount = (String)input.remove("credentials");
        account = StringUtils.isNotEmpty((CharSequence)account) ? account : removedAccount;
        KubernetesNamedAccountCredentials credentials = (KubernetesNamedAccountCredentials)credentialsSupport.getCredentialsObject(account);
        KubernetesAtomicOperationDescription converted = (KubernetesAtomicOperationDescription)credentialsSupport.getObjectMapper().copy().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).convertValue(input, targetDescriptionType);
        converted.setCredentials(credentials);
        if (StringUtils.isNotEmpty((CharSequence)removedAccount)) {
            input.put("credentials", removedAccount);
            converted.setAccount(removedAccount);
        }
        return (T)converted;
    }
}

