/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;

@NonnullByDefault
public final class KubernetesPodMetric {
    private final String podName;
    private final String namespace;
    private final ImmutableList<ContainerMetric> containerMetrics;

    @ParametersAreNullableByDefault
    public KubernetesPodMetric(String podName, String namespace, Iterable<ContainerMetric> containerMetrics) {
        this.podName = Strings.nullToEmpty((String)podName);
        this.namespace = Strings.nullToEmpty((String)namespace);
        this.containerMetrics = Optional.ofNullable(containerMetrics).map(ImmutableList::copyOf).orElseGet(ImmutableList::of);
    }

    @Generated
    public static KubernetesPodMetricBuilder builder() {
        return new KubernetesPodMetricBuilder();
    }

    @Generated
    public String getPodName() {
        return this.podName;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public ImmutableList<ContainerMetric> getContainerMetrics() {
        return this.containerMetrics;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesPodMetric)) {
            return false;
        }
        KubernetesPodMetric other = (KubernetesPodMetric)o;
        String this$podName = this.getPodName();
        String other$podName = other.getPodName();
        if (this$podName == null ? other$podName != null : !this$podName.equals(other$podName)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        ImmutableList<ContainerMetric> this$containerMetrics = this.getContainerMetrics();
        ImmutableList<ContainerMetric> other$containerMetrics = other.getContainerMetrics();
        return !(this$containerMetrics == null ? other$containerMetrics != null : !this$containerMetrics.equals(other$containerMetrics));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $podName = this.getPodName();
        result = result * 59 + ($podName == null ? 43 : $podName.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        ImmutableList<ContainerMetric> $containerMetrics = this.getContainerMetrics();
        result = result * 59 + ($containerMetrics == null ? 43 : $containerMetrics.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesPodMetric(podName=" + this.getPodName() + ", namespace=" + this.getNamespace() + ", containerMetrics=" + this.getContainerMetrics() + ")";
    }

    @Generated
    public static class KubernetesPodMetricBuilder {
        @Generated
        private String podName;
        @Generated
        private String namespace;
        @Generated
        private Iterable<ContainerMetric> containerMetrics;

        @Generated
        KubernetesPodMetricBuilder() {
        }

        @Generated
        public KubernetesPodMetricBuilder podName(String podName) {
            this.podName = podName;
            return this;
        }

        @Generated
        public KubernetesPodMetricBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public KubernetesPodMetricBuilder containerMetrics(Iterable<ContainerMetric> containerMetrics) {
            this.containerMetrics = containerMetrics;
            return this;
        }

        @Generated
        public KubernetesPodMetric build() {
            return new KubernetesPodMetric(this.podName, this.namespace, this.containerMetrics);
        }

        @Generated
        public String toString() {
            return "KubernetesPodMetric.KubernetesPodMetricBuilder(podName=" + this.podName + ", namespace=" + this.namespace + ", containerMetrics=" + this.containerMetrics + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class ContainerMetric {
        private final String containerName;
        private final ImmutableMap<String, String> metrics;

        @JsonCreator
        @ParametersAreNullableByDefault
        public ContainerMetric(@JsonProperty(value="containerName") String containerName, @JsonProperty(value="metrics") Map<String, String> metrics) {
            this.containerName = Strings.nullToEmpty((String)containerName);
            this.metrics = Optional.ofNullable(metrics).map(ImmutableMap::copyOf).orElseGet(ImmutableMap::of);
        }

        @Generated
        public String getContainerName() {
            return this.containerName;
        }

        @Generated
        public ImmutableMap<String, String> getMetrics() {
            return this.metrics;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContainerMetric)) {
                return false;
            }
            ContainerMetric other = (ContainerMetric)o;
            String this$containerName = this.getContainerName();
            String other$containerName = other.getContainerName();
            if (this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName)) {
                return false;
            }
            ImmutableMap<String, String> this$metrics = this.getMetrics();
            ImmutableMap<String, String> other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $containerName = this.getContainerName();
            result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
            ImmutableMap<String, String> $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KubernetesPodMetric.ContainerMetric(containerName=" + this.getContainerName() + ", metrics=" + this.getMetrics() + ")";
        }
    }
}

